/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.jruby;

import cucumber.runtime.ParameterInfo;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.jruby.JRubyBackend;
import gherkin.I18n;
import gherkin.formatter.Argument;
import gherkin.formatter.model.Step;
import java.lang.reflect.Type;
import java.util.List;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyStepDefinition
implements StepDefinition {
    private final JRubyBackend jRubyBackend;
    private final RubyObject stepdefRunner;
    private String file;
    private Long line;

    public JRubyStepDefinition(JRubyBackend jRubyBackend, RubyObject stepdefRunner) {
        this.jRubyBackend = jRubyBackend;
        this.stepdefRunner = stepdefRunner;
    }

    @Override
    public List<Argument> matchedArguments(Step step) {
        RubyString stepName = this.stepdefRunner.getRuntime().newString(step.getName());
        IRubyObject arguments = this.stepdefRunner.callMethod("matched_arguments", new IRubyObject[]{stepName});
        return (List)arguments.toJava(List.class);
    }

    @Override
    public String getLocation(boolean detail) {
        if (this.file == null) {
            List fileAndLine = (List)this.stepdefRunner.callMethod("file_and_line").toJava(List.class);
            this.file = (String)fileAndLine.get(0);
            this.line = (Long)fileAndLine.get(1);
        }
        return this.file + ":" + this.line;
    }

    @Override
    public Integer getParameterCount() {
        IRubyObject paramCountR = this.stepdefRunner.callMethod("param_count");
        return Math.max(0, (Integer)paramCountR.toJava(Integer.class));
    }

    @Override
    public ParameterInfo getParameterType(int n, Type argumentType) {
        return new ParameterInfo(argumentType, null, null, null);
    }

    @Override
    public void execute(I18n i18n, Object[] args) throws Throwable {
        this.jRubyBackend.executeStepdef(this.stepdefRunner, i18n, args);
    }

    @Override
    public boolean isDefinedAt(StackTraceElement stackTraceElement) {
        return this.file.equals(stackTraceElement.getFileName()) && this.line < (long)stackTraceElement.getLineNumber();
    }

    @Override
    public String getPattern() {
        return (String)this.stepdefRunner.callMethod("pattern").toJava(String.class);
    }
}

