/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.xstream;

import cucumber.runtime.xstream.CellWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MapWriter
extends CellWriter {
    private final List<String> columnNames;
    private final Map<String, Object> values = new LinkedHashMap<String, Object>();
    private String key;

    public MapWriter(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public List<String> getHeader() {
        return this.columnNames.isEmpty() ? new ArrayList<String>(this.values.keySet()) : this.columnNames;
    }

    @Override
    public List<String> getValues() {
        ArrayList<String> values = new ArrayList<String>(this.columnNames.size());
        for (String columnName : this.getHeader()) {
            Object value = this.values.get(columnName);
            values.add(value == null ? "" : value.toString());
        }
        return values;
    }

    @Override
    public void setValue(String value) {
        if (this.key == null) {
            this.key = value;
        } else {
            this.values.put(this.key, value);
            this.key = null;
        }
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startNode(String name) {
    }

    @Override
    public void addAttribute(String name, String value) {
    }

    @Override
    public void endNode() {
    }
}

