/*
 * Decompiled with CFR 0.152.
 */
package cucumber.junit;

import cucumber.junit.JUnitReporter;
import cucumber.runtime.Runtime;
import cucumber.runtime.World;
import cucumber.runtime.model.CucumberScenario;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Step;
import java.lang.annotation.Annotation;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

class ExecutionUnitRunner
extends ParentRunner<Step> {
    private final Runtime runtime;
    private final CucumberScenario cucumberScenario;
    private final JUnitReporter jUnitReporter;
    private World world;

    public ExecutionUnitRunner(Runtime runtime, CucumberScenario cucumberScenario, JUnitReporter jUnitReporter) throws InitializationError {
        super(ExecutionUnitRunner.class);
        this.runtime = runtime;
        this.cucumberScenario = cucumberScenario;
        this.jUnitReporter = jUnitReporter;
    }

    protected List<Step> getChildren() {
        return this.cucumberScenario.getSteps();
    }

    public String getName() {
        return this.cucumberScenario.getVisualName();
    }

    protected Description describeChild(Step step) {
        return Description.createSuiteDescription((String)(step.getKeyword() + step.getName() + "(" + this.getName() + ")"), (Annotation[])new Annotation[0]);
    }

    public void run(RunNotifier notifier) {
        this.jUnitReporter.startExecutionUnit(this, notifier);
        this.world = this.cucumberScenario.newWorld(this.runtime);
        this.world.buildBackendWorldsAndRunBeforeHooks((Reporter)this.jUnitReporter);
        this.cucumberScenario.runBackground(this.jUnitReporter.getFormatter(), this.jUnitReporter.getReporter());
        this.cucumberScenario.format((Formatter)this.jUnitReporter);
        super.run(notifier);
        this.world.runAfterHooksAndDisposeBackendWorlds((Reporter)this.jUnitReporter);
        this.jUnitReporter.finishExecutionUnit();
    }

    protected void runChild(Step step, RunNotifier notifier) {
        this.cucumberScenario.runStep(step, (Reporter)this.jUnitReporter, this.world);
    }
}

