/*
 * Decompiled with CFR 0.152.
 */
package cucumber.junit;

import cucumber.formatter.NullReporter;
import cucumber.io.ClasspathResourceLoader;
import cucumber.io.ResourceLoader;
import cucumber.junit.Feature;
import cucumber.junit.FeatureRunner;
import cucumber.junit.JUnitReporter;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Runtime;
import cucumber.runtime.Utils;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.snippets.SummaryPrinter;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class Cucumber
extends ParentRunner<FeatureRunner> {
    private final ResourceLoader resourceLoader;
    private final JUnitReporter jUnitReporter;
    private final List<FeatureRunner> children = new ArrayList<FeatureRunner>();
    private final Runtime runtime;

    public Cucumber(Class clazz) throws InitializationError, IOException {
        super(clazz);
        ClassLoader classLoader = clazz.getClassLoader();
        this.resourceLoader = new ClasspathResourceLoader(classLoader);
        this.assertNoDeclaredMethods(clazz);
        List<String> featurePaths = this.featurePaths(clazz);
        List<String> gluePaths = this.gluePaths(clazz);
        this.runtime = new Runtime(this.resourceLoader, gluePaths, classLoader);
        this.jUnitReporter = new JUnitReporter((Reporter)new NullReporter(), (Formatter)new NullReporter());
        this.addChildren(featurePaths, this.filters(clazz));
    }

    protected List<FeatureRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(FeatureRunner child) {
        return child.getDescription();
    }

    protected void runChild(FeatureRunner child, RunNotifier notifier) {
        child.run(notifier);
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
        this.jUnitReporter.done();
        new SummaryPrinter(System.out).print(this.runtime);
    }

    private void assertNoDeclaredMethods(Class clazz) {
        if (clazz.getDeclaredMethods().length != 0) {
            throw new CucumberException("\n\nClasses annotated with @RunWith(Cucumber.class) must not define any methods.\nTheir sole purpose is to serve as an entry point for JUnit.\nStep Definitions should be defined in their own classes.\nThis allows them to be reused across features.\nOffending class: " + clazz + "\n");
        }
    }

    private List<String> featurePaths(Class clazz) {
        Feature featureAnnotation = this.getFeatureAnnotation(clazz);
        String featurePath = featureAnnotation != null ? featureAnnotation.value() : Utils.packagePath((Class)clazz);
        return Arrays.asList(featurePath);
    }

    private List<String> gluePaths(Class clazz) {
        ArrayList<String> gluePaths = new ArrayList<String>();
        gluePaths.add(Utils.packagePath((Class)clazz));
        Feature featureAnnotation = this.getFeatureAnnotation(clazz);
        if (featureAnnotation != null) {
            for (String packageName : featureAnnotation.packages()) {
                gluePaths.add(Utils.packagePath((String)packageName));
            }
        }
        return gluePaths;
    }

    private List<Object> filters(Class clazz) {
        Feature featureAnnotation = this.getFeatureAnnotation(clazz);
        Object[] filters = new Object[]{};
        if (featureAnnotation != null && (filters = this.toLong(featureAnnotation.lines())).length == 0) {
            filters = featureAnnotation.tags();
        }
        return Arrays.asList(filters);
    }

    private void addChildren(List<String> featurePaths, List<Object> filters) throws InitializationError {
        List cucumberFeatures = CucumberFeature.load((ResourceLoader)this.resourceLoader, featurePaths, filters);
        for (CucumberFeature cucumberFeature : cucumberFeatures) {
            this.children.add(new FeatureRunner(cucumberFeature, this.runtime, this.jUnitReporter));
        }
    }

    private Long[] toLong(long[] primitiveLongs) {
        Long[] longs = new Long[primitiveLongs.length];
        for (int i = 0; i < primitiveLongs.length; ++i) {
            longs[i] = primitiveLongs[i];
        }
        return longs;
    }

    private Feature getFeatureAnnotation(Class clazz) {
        return clazz.getAnnotation(Feature.class);
    }
}

