/*
 * Decompiled with CFR 0.152.
 */
package cucumber.junit;

import cucumber.junit.ExecutionUnitRunner;
import cucumber.runtime.PendingException;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import java.util.List;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;

class JUnitReporter
implements Reporter,
Formatter {
    private final List<Step> steps = new ArrayList<Step>();
    private final Reporter reporter;
    private final Formatter formatter;
    private EachTestNotifier stepNotifier;
    private ExecutionUnitRunner executionUnitRunner;
    private RunNotifier runNotifier;
    private EachTestNotifier executionUnitNotifier;

    public JUnitReporter(Reporter reporter, Formatter formatter) {
        this.reporter = reporter;
        this.formatter = formatter;
    }

    public void startExecutionUnit(ExecutionUnitRunner executionUnitRunner, RunNotifier runNotifier) {
        this.executionUnitRunner = executionUnitRunner;
        this.runNotifier = runNotifier;
        this.stepNotifier = null;
        this.executionUnitNotifier = new EachTestNotifier(runNotifier, executionUnitRunner.getDescription());
        this.executionUnitNotifier.fireTestStarted();
    }

    public void finishExecutionUnit() {
        this.executionUnitNotifier.fireTestFinished();
    }

    public void match(Match match) {
        Description description = this.executionUnitRunner.describeChild(this.steps.remove(0));
        this.stepNotifier = new EachTestNotifier(this.runNotifier, description);
        this.stepNotifier.fireTestStarted();
        this.reporter.match(match);
    }

    public void embedding(String mimeType, byte[] data) {
        this.reporter.embedding(mimeType, data);
    }

    public void result(Result result) {
        Throwable error = result.getError();
        if (Result.SKIPPED == result || Result.UNDEFINED == result || error instanceof PendingException) {
            this.stepNotifier.fireTestIgnored();
        } else if (this.stepNotifier != null) {
            if (error != null) {
                this.stepNotifier.addFailure(error);
            }
            this.stepNotifier.fireTestFinished();
        } else if (error != null) {
            this.executionUnitNotifier.addFailure(error);
        }
        this.reporter.result(result);
    }

    public void uri(String uri) {
        this.formatter.uri(uri);
    }

    public void feature(Feature feature) {
        this.formatter.feature(feature);
    }

    public void background(Background background) {
        this.formatter.background(background);
    }

    public void scenario(Scenario scenario) {
        this.formatter.scenario(scenario);
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.formatter.scenarioOutline(scenarioOutline);
    }

    public void examples(Examples examples) {
        this.formatter.examples(examples);
    }

    public void step(Step step) {
        this.steps.add(step);
        this.formatter.step(step);
    }

    public void eof() {
        this.formatter.eof();
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, int line) {
        this.formatter.syntaxError(state, event, legalEvents, uri, line);
    }

    public void done() {
        this.formatter.done();
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public Reporter getReporter() {
        return this.reporter;
    }
}

