/*
 * Decompiled with CFR 0.152.
 */
package cucumber.junit;

import cucumber.io.ClasspathResourceLoader;
import cucumber.io.ResourceLoader;
import cucumber.junit.FeatureRunner;
import cucumber.junit.JUnitReporter;
import cucumber.junit.RuntimeOptionsFactory;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.snippets.SummaryPrinter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class Cucumber
extends ParentRunner<FeatureRunner> {
    private final JUnitReporter jUnitReporter;
    private final List<FeatureRunner> children = new ArrayList<FeatureRunner>();
    private final Runtime runtime;

    public Cucumber(Class clazz) throws InitializationError, IOException {
        super(clazz);
        ClassLoader classLoader = clazz.getClassLoader();
        ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader(classLoader);
        Cucumber.assertNoCucumberAnnotatedMethods(clazz);
        RuntimeOptionsFactory runtimeOptionsFactory = new RuntimeOptionsFactory(clazz);
        RuntimeOptions runtimeOptions = runtimeOptionsFactory.create();
        this.runtime = new Runtime((ResourceLoader)resourceLoader, classLoader, runtimeOptions);
        this.jUnitReporter = new JUnitReporter(runtimeOptions.reporter(classLoader), runtimeOptions.formatter(classLoader));
        this.addChildren(runtimeOptions.cucumberFeatures((ResourceLoader)resourceLoader));
    }

    protected List<FeatureRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(FeatureRunner child) {
        return child.getDescription();
    }

    protected void runChild(FeatureRunner child, RunNotifier notifier) {
        child.run(notifier);
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
        this.jUnitReporter.done();
        new SummaryPrinter(System.out).print(this.runtime);
        this.jUnitReporter.close();
    }

    static void assertNoCucumberAnnotatedMethods(Class clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotation.annotationType().getName().startsWith("cucumber")) continue;
                throw new CucumberException("\n\nClasses annotated with @RunWith(Cucumber.class) must not define any\nStep Definition or Hook methods. Their sole purpose is to serve as\nan entry point for JUnit. Step Definitions and Hooks should be defined\nin their own classes. This allows them to be reused across features.\nOffending class: " + clazz + "\n");
            }
        }
    }

    private void addChildren(List<CucumberFeature> cucumberFeatures) throws InitializationError {
        for (CucumberFeature cucumberFeature : cucumberFeatures) {
            this.children.add(new FeatureRunner(cucumberFeature, this.runtime, this.jUnitReporter));
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Options {
        public boolean dryRun() default false;

        public String[] features() default {};

        public String[] glue() default {};

        public String[] tags() default {};

        public String[] format() default {};

        public boolean monochrome() default false;
    }
}

