/*
 * Decompiled with CFR 0.152.
 */
package cucumber.junit;

import cucumber.junit.DescriptionFactory;
import cucumber.junit.ExecutionUnitRunner;
import cucumber.junit.JUnitReporter;
import cucumber.runtime.Runtime;
import cucumber.runtime.model.CucumberExamples;
import cucumber.runtime.model.CucumberScenario;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;

class ExamplesRunner
extends Suite {
    private final CucumberExamples cucumberExamples;
    private Description description;

    protected ExamplesRunner(Runtime runtime, CucumberExamples cucumberExamples, JUnitReporter jUnitReporter) throws InitializationError {
        super(ExamplesRunner.class, new ArrayList());
        this.cucumberExamples = cucumberExamples;
        List exampleScenarios = cucumberExamples.createExampleScenarios();
        for (CucumberScenario scenario : exampleScenarios) {
            try {
                ExecutionUnitRunner exampleScenarioRunner = new ExecutionUnitRunner(runtime, scenario, jUnitReporter);
                this.getChildren().add(exampleScenarioRunner);
            }
            catch (InitializationError initializationError) {
                initializationError.printStackTrace();
            }
        }
    }

    protected String getName() {
        return this.cucumberExamples.getExamples().getKeyword() + ": " + this.cucumberExamples.getExamples().getName();
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = DescriptionFactory.createDescription(this.getName(), this.cucumberExamples);
            for (Runner child : this.getChildren()) {
                this.description.addChild(this.describeChild(child));
            }
        }
        return this.description;
    }
}

