/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.junit;

import cucumber.api.junit.Cucumber;
import cucumber.runtime.RuntimeOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RuntimeOptionsFactory {
    private final Class clazz;

    public RuntimeOptionsFactory(Class clazz) {
        this.clazz = clazz;
    }

    public RuntimeOptions create() {
        ArrayList<String> args = new ArrayList<String>();
        Cucumber.Options options = this.getOptions(this.clazz);
        this.addDryRun(options, args);
        this.addMonochrome(options, args);
        this.addGlue(options, args, this.clazz);
        this.addTags(options, args);
        this.addFormats(options, args);
        this.addFeatures(options, args, this.clazz);
        this.addStrict(options, args);
        this.addName(options, args);
        this.addDotCucumber(options, args);
        RuntimeOptions runtimeOptions = new RuntimeOptions(System.getProperties(), args.toArray(new String[args.size()]));
        return runtimeOptions;
    }

    private void addDotCucumber(Cucumber.Options options, List<String> args) {
        if (options != null && !options.dotcucumber().isEmpty()) {
            args.add("--dotcucumber");
            args.add(options.dotcucumber());
        }
    }

    private void addName(Cucumber.Options options, List<String> args) {
        if (options != null && options.name().length != 0) {
            for (String name : options.name()) {
                args.add("--name");
                args.add(name);
            }
        }
    }

    private Cucumber.Options getOptions(Class<?> clazz) {
        return clazz.getAnnotation(Cucumber.Options.class);
    }

    private void addDryRun(Cucumber.Options options, List<String> args) {
        if (options != null && options.dryRun()) {
            args.add("--dry-run");
        }
    }

    private void addMonochrome(Cucumber.Options options, List<String> args) {
        if (options != null && (options.monochrome() || this.runningInEnvironmentWithoutAnsiSupport())) {
            args.add("--monochrome");
        }
    }

    private boolean runningInEnvironmentWithoutAnsiSupport() {
        boolean intelliJidea = System.getProperty("idea.launcher.bin.path") != null;
        return intelliJidea;
    }

    private void addGlue(Cucumber.Options options, List<String> args, Class clazz) {
        if (options != null && options.glue().length != 0) {
            for (String glue : options.glue()) {
                args.add("--glue");
                args.add(glue);
            }
        } else {
            args.add("--glue");
            args.add("classpath:" + RuntimeOptionsFactory.packagePath(clazz));
        }
    }

    private void addTags(Cucumber.Options options, List<String> args) {
        if (options != null) {
            for (String tags : options.tags()) {
                args.add("--tags");
                args.add(tags);
            }
        }
    }

    private void addFormats(Cucumber.Options options, List<String> args) {
        if (options != null && options.format().length != 0) {
            for (String format : options.format()) {
                args.add("--format");
                args.add(format);
            }
        } else {
            args.add("--format");
            args.add("null");
        }
    }

    private void addFeatures(Cucumber.Options options, List<String> args, Class clazz) {
        if (options != null && options.features().length != 0) {
            Collections.addAll(args, options.features());
        } else {
            args.add("classpath:" + RuntimeOptionsFactory.packagePath(clazz));
        }
    }

    private void addStrict(Cucumber.Options options, List<String> args) {
        if (options != null && options.strict()) {
            args.add("--strict");
        }
    }

    static String packagePath(Class clazz) {
        return RuntimeOptionsFactory.packagePath(RuntimeOptionsFactory.packageName(clazz.getName()));
    }

    static String packagePath(String packageName) {
        return packageName.replace('.', '/');
    }

    static String packageName(String className) {
        return className.substring(0, Math.max(0, className.lastIndexOf(".")));
    }
}

