/*
 * Decompiled with CFR 0.152.
 */
package cucumber.pro.scm;

import cucumber.pro.scm.Exec;
import cucumber.pro.scm.WorkingCopy;
import java.io.File;
import java.util.List;

class GitWorkingCopy
implements WorkingCopy {
    private final File rootDir;
    private final Exec exec;

    public static GitWorkingCopy detect(File dir) {
        File workingCopyRoot = null;
        while (dir != null) {
            File dotSvn = new File(dir, ".git");
            if (dotSvn.isDirectory()) {
                workingCopyRoot = dir;
            }
            dir = dir.getParentFile();
        }
        return workingCopyRoot != null ? new GitWorkingCopy(workingCopyRoot) : null;
    }

    public GitWorkingCopy(File rootDir) {
        this.rootDir = rootDir;
        this.exec = new Exec(rootDir);
    }

    @Override
    public String getRev() {
        return this.exec.cmd("git rev-parse HEAD").get(0);
    }

    @Override
    public String getRepoUrl() {
        List<String> remotes = this.exec.cmd("git ls-remote --get-url");
        for (String remote : remotes) {
            if (!remote.contains("github") && !remote.contains("bitbucket")) continue;
            return remote;
        }
        return this.exec.cmd("git config --get remote.origin.url").get(0);
    }

    @Override
    public String getBranch() {
        String rawBranch = this.getRawBranch();
        String[] branchElements = rawBranch.split("/");
        return branchElements[branchElements.length - 1];
    }

    private String getRawBranch() {
        List<String> branches = this.exec.cmd("git branch --contains " + this.getRev());
        for (String branch : branches) {
            if (branch.contains("* (detached from")) continue;
            return branch.substring(2);
        }
        return this.exec.cmd("git name-rev --name-only HEAD").get(0);
    }

    @Override
    public void checkClean() {
        this.checkNoModifications();
        this.checkCurrentBranchPushed();
    }

    private void checkNoModifications() {
        List<String> dirtyFiles = this.exec.cmd("git status --untracked-files=no --porcelain");
        if (!dirtyFiles.isEmpty()) {
            throw new RuntimeException("Please commit and push your changes before running with the Cucumber Pro formatter.");
        }
    }

    private void checkCurrentBranchPushed() {
        String branch = this.getBranch();
        List<String> unpushedCommits = this.exec.cmd(String.format("git log origin/%s..%s --oneline", branch, branch));
        if (!unpushedCommits.isEmpty()) {
            throw new RuntimeException("Your current branch has commits that haven't been pushed to origin. Please push your changes before running with the Cucumber Pro formatter.");
        }
    }

    File getRootDir() {
        return this.rootDir;
    }
}

