/*
 * Decompiled with CFR 0.152.
 */
package cucumber.pro.scm;

import cucumber.pro.Global;
import cucumber.pro.scm.CustomWorkingCopy;
import cucumber.pro.scm.GitWorkingCopy;
import cucumber.pro.scm.SvnWorkingCopy;
import cucumber.pro.scm.WorkingCopy;
import java.io.File;

public class WorkingCopyDetector {
    private static final File PWD = new File(System.getProperty("user.dir"));

    public static WorkingCopy detect() {
        WorkingCopy result = GitWorkingCopy.detect(PWD);
        if (result == null) {
            result = SvnWorkingCopy.detect(PWD);
        }
        if (result == null) {
            String repoUrl = WorkingCopyDetector.getEnv("CUCUMBER_PRO_REPO_URL");
            String branch = WorkingCopyDetector.getEnv("CUCUMBER_PRO_BRANCH");
            String rev = WorkingCopyDetector.getEnv("CUCUMBER_PRO_REV");
            return new CustomWorkingCopy(repoUrl, branch, rev);
        }
        return result;
    }

    private static String getEnv(String key) {
        String value = Global.ENV.get(key);
        if (value == null) {
            String message = "No git or subversion working copy detected. You must define the " + key + " environment variable.";
            throw new RuntimeException(message);
        }
        return value;
    }
}

