/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java.spring;

import cucumber.runtime.CucumberException;
import cucumber.runtime.java.ObjectFactory;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.CommonAnnotationBeanPostProcessor;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

public class SpringFactory
implements ObjectFactory {
    private static AbstractApplicationContext applicationContext = new ClassPathXmlApplicationContext(new String[]{"cucumber.xml"});
    private StaticApplicationContext stepContext;
    private final Collection<Class<?>> stepClasses = new ArrayList();

    public void addClass(Class<?> clazz) {
        this.stepClasses.add(clazz);
    }

    public void createInstances() {
        this.createNewStepContext();
        this.populateStepContext();
    }

    private void createNewStepContext() {
        this.stepContext = new StaticApplicationContext((ApplicationContext)applicationContext);
        AutowiredAnnotationBeanPostProcessor autowirer = new AutowiredAnnotationBeanPostProcessor();
        autowirer.setBeanFactory((BeanFactory)this.stepContext.getBeanFactory());
        this.stepContext.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)autowirer);
        this.stepContext.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)new CommonAnnotationBeanPostProcessor());
    }

    private void populateStepContext() {
        for (Class<?> stepClass : this.stepClasses) {
            this.stepContext.registerSingleton(stepClass.getName(), stepClass);
        }
        this.stepContext.refresh();
    }

    public void disposeInstances() {
        this.stepContext.close();
    }

    public <T> T getInstance(Class<T> type) {
        try {
            return (T)this.stepContext.getBean(type);
        }
        catch (NoSuchBeanDefinitionException exception) {
            throw new CucumberException(exception.getMessage(), (Throwable)exception);
        }
    }

    static {
        applicationContext.registerShutdownHook();
    }
}

