/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java.spring;

import cucumber.runtime.CucumberException;
import cucumber.runtime.java.ObjectFactory;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringFactory
implements ObjectFactory {
    private static AbstractApplicationContext applicationContext = new ClassPathXmlApplicationContext(new String[]{"cucumber.xml"});
    private ClassPathXmlApplicationContext stepContext;
    private final Collection<Class<?>> stepClasses = new ArrayList();

    public void addClass(Class<?> clazz) {
        this.stepClasses.add(clazz);
    }

    public void createInstances() {
        this.createNewStepContext();
        this.populateStepContext();
    }

    private void createNewStepContext() {
        this.stepContext = new ClassPathXmlApplicationContext(new String[]{"classpath*:cucumber-glue.xml"}, (ApplicationContext)applicationContext);
    }

    private void populateStepContext() {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.stepContext.getAutowireCapableBeanFactory();
        for (Class<?> stepClass : this.stepClasses) {
            registry.registerBeanDefinition(stepClass.getName(), (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(stepClass).getBeanDefinition());
        }
    }

    public void disposeInstances() {
        this.stepContext.close();
    }

    public <T> T getInstance(Class<T> type) {
        try {
            return (T)this.stepContext.getBean(type);
        }
        catch (NoSuchBeanDefinitionException exception) {
            throw new CucumberException(exception.getMessage(), (Throwable)exception);
        }
    }

    static {
        applicationContext.registerShutdownHook();
    }
}

