/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java.spring;

import cucumber.runtime.CucumberException;
import cucumber.runtime.java.ObjectFactory;
import cucumber.runtime.java.spring.GlueCodeContext;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringFactory
implements ObjectFactory {
    private static AbstractApplicationContext applicationContext = new ClassPathXmlApplicationContext(new String[]{"cucumber/runtime/java/spring/cucumber-glue.xml", "cucumber.xml"});
    private final Collection<Class<?>> stepClasses = new HashSet();

    public void addClass(Class<?> stepClass) {
        if (!this.stepClasses.contains(stepClass)) {
            this.stepClasses.add(stepClass);
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)applicationContext.getAutowireCapableBeanFactory();
            registry.registerBeanDefinition(stepClass.getName(), (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(stepClass).setScope("cucumber-glue").getBeanDefinition());
        }
    }

    public void createInstances() {
        GlueCodeContext.INSTANCE.start();
    }

    public void disposeInstances() {
        GlueCodeContext.INSTANCE.stop();
    }

    public <T> T getInstance(Class<T> type) {
        try {
            return (T)applicationContext.getBean(type);
        }
        catch (NoSuchBeanDefinitionException exception) {
            throw new CucumberException(exception.getMessage(), (Throwable)exception);
        }
    }

    static {
        applicationContext.registerShutdownHook();
    }
}

