/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java.spring.hooks;

import cucumber.annotation.After;
import cucumber.annotation.Before;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SpringTransactionHooks
implements BeanFactoryAware {
    private BeanFactory beanFactory;
    private String txnManagerBeanName;
    TransactionStatus txStatus;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public String getTxnManagerBeanName() {
        return this.txnManagerBeanName;
    }

    public void setTxnManagerBeanName(String txnManagerBeanName) {
        this.txnManagerBeanName = txnManagerBeanName;
    }

    @Before(value={"@txn"})
    public void rollBackBeforeHook() {
        this.txStatus = this.obtainPlatformTransactionManager().getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
    }

    @After(value={"@txn"})
    public void rollBackAfterHook() {
        this.obtainPlatformTransactionManager().rollback(this.txStatus);
    }

    PlatformTransactionManager obtainPlatformTransactionManager() {
        if (this.getTxnManagerBeanName() == null) {
            return (PlatformTransactionManager)this.beanFactory.getBean(PlatformTransactionManager.class);
        }
        return (PlatformTransactionManager)this.beanFactory.getBean(this.txnManagerBeanName, PlatformTransactionManager.class);
    }
}

