/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java.spring;

import cucumber.runtime.CucumberException;
import cucumber.runtime.java.ObjectFactory;
import cucumber.runtime.java.spring.GlueCodeContext;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.test.context.TestContextManager;

public class SpringFactory
implements ObjectFactory {
    private static ConfigurableApplicationContext applicationContext = new GenericXmlApplicationContext(new String[]{"cucumber/runtime/java/spring/cucumber-glue.xml"});
    private final Collection<Class<?>> stepClasses = new HashSet();

    public void addClass(Class<?> stepClass) {
        if (!this.stepClasses.contains(stepClass)) {
            this.stepClasses.add(stepClass);
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)applicationContext.getAutowireCapableBeanFactory();
            AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(stepClass).setScope("cucumber-glue").getBeanDefinition();
            registry.registerBeanDefinition(stepClass.getName(), (BeanDefinition)beanDefinition);
        }
    }

    public void start() {
        GlueCodeContext.INSTANCE.start();
    }

    public void stop() {
        GlueCodeContext.INSTANCE.stop();
        applicationContext.getBeanFactory().destroySingletons();
    }

    public <T> T getInstance(Class<T> type) {
        if (!applicationContext.getBeanFactory().containsSingleton(type.getName())) {
            applicationContext.getBeanFactory().registerSingleton(type.getName(), this.getTestInstance(type));
        }
        return (T)applicationContext.getBean(type);
    }

    private <T> T getTestInstance(Class<T> type) {
        try {
            T instance = this.createTest(type);
            TestContextManager contextManager = new TestContextManager(type);
            contextManager.prepareTestInstance(instance);
            return instance;
        }
        catch (Exception e) {
            throw new CucumberException(e.getMessage(), (Throwable)e);
        }
    }

    protected <T> T createTest(Class<T> type) throws Exception {
        return (T)type.getConstructors()[0].newInstance(new Object[0]);
    }

    static {
        applicationContext.registerShutdownHook();
    }
}

