/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java.spring;

import cucumber.runtime.CucumberException;
import cucumber.runtime.java.ObjectFactory;
import cucumber.runtime.java.spring.GlueCodeContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextHierarchy;
import org.springframework.test.context.TestContextManager;

public class SpringFactory
implements ObjectFactory {
    private static ConfigurableApplicationContext applicationContext = new GenericXmlApplicationContext(new String[]{"cucumber/runtime/java/spring/cucumber-glue.xml"});
    private static ConfigurableListableBeanFactory beanFactory;
    private final Collection<Class<?>> stepClasses = new HashSet();
    private final Map<Class<?>, TestContextManager> contextManagersByClass = new HashMap();

    public void addClass(Class<?> stepClass) {
        if (!this.stepClasses.contains(stepClass)) {
            this.stepClasses.add(stepClass);
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)applicationContext.getAutowireCapableBeanFactory();
            AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(stepClass).setScope("cucumber-glue").getBeanDefinition();
            registry.registerBeanDefinition(stepClass.getName(), (BeanDefinition)beanDefinition);
        }
    }

    public void start() {
        GlueCodeContext.INSTANCE.start();
    }

    public void stop() {
        this.notifyContextManagersAboutTestClassFinished();
        GlueCodeContext.INSTANCE.stop();
        beanFactory.destroySingletons();
    }

    private void notifyContextManagersAboutTestClassFinished() {
        HashMap exceptionsThrown = new HashMap();
        for (Map.Entry<Class<?>, TestContextManager> classTestContextManagerEntry : this.contextManagersByClass.entrySet()) {
            try {
                classTestContextManagerEntry.getValue().afterTestClass();
            }
            catch (Exception e) {
                exceptionsThrown.put(classTestContextManagerEntry.getKey(), e);
            }
        }
        this.contextManagersByClass.clear();
        this.rethrowExceptionsIfAny(exceptionsThrown);
    }

    private void rethrowExceptionsIfAny(Map<Class<?>, Exception> exceptionsThrown) {
        if (exceptionsThrown.isEmpty()) {
            return;
        }
        if (exceptionsThrown.size() == 1) {
            Exception e = exceptionsThrown.values().iterator().next();
            throw new CucumberException(e.getMessage(), (Throwable)e);
        }
        throw new CucumberException(this.getMultipleExceptionMessage(exceptionsThrown));
    }

    private String getMultipleExceptionMessage(Map<Class<?>, Exception> exceptionsThrow) {
        StringBuilder exceptionsThrown = new StringBuilder(1000);
        exceptionsThrown.append("Multiple exceptions occurred during processing of the TestExecutionListeners\n\n");
        for (Map.Entry<Class<?>, Exception> classExceptionEntry : exceptionsThrow.entrySet()) {
            exceptionsThrown.append("Exception during processing of TestExecutionListeners of ");
            exceptionsThrown.append(classExceptionEntry.getKey());
            exceptionsThrown.append('\n');
            exceptionsThrown.append(classExceptionEntry.getValue().toString());
            exceptionsThrown.append('\n');
            StringWriter stackTraceStringWriter = new StringWriter();
            PrintWriter stackTracePrintWriter = new PrintWriter(stackTraceStringWriter);
            classExceptionEntry.getValue().printStackTrace(stackTracePrintWriter);
            exceptionsThrown.append(stackTraceStringWriter.toString());
            exceptionsThrown.append('\n');
        }
        return exceptionsThrown.toString();
    }

    public <T> T getInstance(Class<T> type) {
        if (!beanFactory.containsSingleton(type.getName())) {
            beanFactory.registerSingleton(type.getName(), this.getTestInstance(type));
        }
        return (T)applicationContext.getBean(type);
    }

    private <T> T getTestInstance(Class<T> type) {
        try {
            T instance = this.createTest(type);
            if (this.dependsOnSpringContext(type)) {
                TestContextManager contextManager = new TestContextManager(type);
                contextManager.prepareTestInstance(instance);
                contextManager.beforeTestClass();
                this.contextManagersByClass.put(type, contextManager);
            }
            return instance;
        }
        catch (Exception e) {
            throw new CucumberException(e.getMessage(), (Throwable)e);
        }
    }

    protected <T> T createTest(Class<T> type) throws Exception {
        return (T)type.getConstructors()[0].newInstance(new Object[0]);
    }

    private boolean dependsOnSpringContext(Class<?> type) {
        return type.isAnnotationPresent(ContextConfiguration.class) || type.isAnnotationPresent(ContextHierarchy.class);
    }

    static {
        applicationContext.registerShutdownHook();
        beanFactory = applicationContext.getBeanFactory();
    }
}

