/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java.spring;

import cucumber.api.java.ObjectFactory;
import cucumber.runtime.CucumberException;
import cucumber.runtime.java.spring.CucumberTestContextManager;
import cucumber.runtime.java.spring.GlueCodeContext;
import cucumber.runtime.java.spring.GlueCodeScope;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextHierarchy;

public class SpringFactory
implements ObjectFactory {
    private ConfigurableListableBeanFactory beanFactory;
    private CucumberTestContextManager testContextManager;
    private final Collection<Class<?>> stepClasses = new HashSet();
    private Class<?> stepClassWithSpringContext = null;

    public void addClass(Class<?> stepClass) {
        if (!this.stepClasses.contains(stepClass)) {
            if (this.dependsOnSpringContext(stepClass)) {
                if (this.stepClassWithSpringContext == null) {
                    this.stepClassWithSpringContext = stepClass;
                } else {
                    this.checkAnnotationsEqual(this.stepClassWithSpringContext, stepClass);
                }
            }
            this.stepClasses.add(stepClass);
        }
    }

    private void checkAnnotationsEqual(Class<?> stepClassWithSpringContext, Class<?> stepClass) {
        Annotation[] annotations2;
        Annotation[] annotations1 = stepClassWithSpringContext.getAnnotations();
        if (annotations1.length != (annotations2 = stepClass.getAnnotations()).length) {
            throw new CucumberException("Annotations differs on glue classes found: " + stepClassWithSpringContext.getName() + ", " + stepClass.getName());
        }
        for (Annotation annotation : annotations1) {
            if (this.isAnnotationInArray(annotation, annotations2)) continue;
            throw new CucumberException("Annotations differs on glue classes found: " + stepClassWithSpringContext.getName() + ", " + stepClass.getName());
        }
    }

    private boolean isAnnotationInArray(Annotation annotation, Annotation[] annotations) {
        for (Annotation annotationFromArray : annotations) {
            if (!annotation.equals(annotationFromArray)) continue;
            return true;
        }
        return false;
    }

    public void start() {
        if (this.stepClassWithSpringContext != null) {
            this.testContextManager = new CucumberTestContextManager(this.stepClassWithSpringContext);
        } else if (this.beanFactory == null) {
            this.beanFactory = this.createFallbackContext();
        }
        this.notifyContextManagerAboutTestClassStarted();
        if (this.beanFactory == null || this.isNewContextCreated()) {
            this.beanFactory = this.testContextManager.getBeanFactory();
            for (Class<?> stepClass : this.stepClasses) {
                this.registerStepClassBeanDefinition(this.beanFactory, stepClass);
            }
        }
        GlueCodeContext.INSTANCE.start();
    }

    private ConfigurableListableBeanFactory createFallbackContext() {
        Object applicationContext = this.getClass().getClassLoader().getResource("cucumber.xml") != null ? new ClassPathXmlApplicationContext("cucumber.xml") : new GenericApplicationContext();
        applicationContext.registerShutdownHook();
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        beanFactory.registerScope("cucumber-glue", (Scope)new GlueCodeScope());
        for (Class<?> stepClass : this.stepClasses) {
            this.registerStepClassBeanDefinition(beanFactory, stepClass);
        }
        return beanFactory;
    }

    private void notifyContextManagerAboutTestClassStarted() {
        if (this.testContextManager != null) {
            try {
                this.testContextManager.beforeTestClass();
            }
            catch (Exception e) {
                throw new CucumberException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isNewContextCreated() {
        if (this.testContextManager == null) {
            return false;
        }
        return !this.beanFactory.equals(this.testContextManager.getBeanFactory());
    }

    private void registerStepClassBeanDefinition(ConfigurableListableBeanFactory beanFactory, Class<?> stepClass) {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(stepClass).setScope("cucumber-glue").getBeanDefinition();
        registry.registerBeanDefinition(stepClass.getName(), (BeanDefinition)beanDefinition);
    }

    public void stop() {
        this.notifyContextManagerAboutTestClassFinished();
        GlueCodeContext.INSTANCE.stop();
    }

    private void notifyContextManagerAboutTestClassFinished() {
        if (this.testContextManager != null) {
            try {
                this.testContextManager.afterTestClass();
            }
            catch (Exception e) {
                throw new CucumberException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public <T> T getInstance(Class<T> type) {
        try {
            return (T)this.beanFactory.getBean(type);
        }
        catch (BeansException e) {
            throw new CucumberException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean dependsOnSpringContext(Class<?> type) {
        boolean hasStandardAnnotations = this.annotatedWithSupportedSpringRootTestAnnotations(type);
        if (hasStandardAnnotations) {
            return true;
        }
        Annotation[] annotations = type.getDeclaredAnnotations();
        return annotations.length == 1 && this.annotatedWithSupportedSpringRootTestAnnotations(annotations[0].annotationType());
    }

    private boolean annotatedWithSupportedSpringRootTestAnnotations(Class<?> type) {
        return type.isAnnotationPresent(ContextConfiguration.class) || type.isAnnotationPresent(ContextHierarchy.class);
    }
}

