/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api.testng;

import cucumber.runtime.Utils;
import gherkin.formatter.Formatter;
import gherkin.formatter.NiceAppendable;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.util.LinkedList;
import java.util.List;
import org.testng.ITestResult;
import org.testng.Reporter;

public class TestNgReporter
implements Formatter,
gherkin.formatter.Reporter {
    private final NiceAppendable out;
    private final LinkedList<Step> steps = new LinkedList();

    public TestNgReporter(Appendable appendable) {
        this.out = new NiceAppendable(appendable);
    }

    public void uri(String uri) {
        String keyword = "Feature File";
        this.logDiv(keyword, uri, "featureFile");
    }

    public void feature(Feature feature) {
        this.logDiv(feature.getKeyword(), feature.getName(), "feature");
    }

    public void background(Background background) {
    }

    public void scenario(Scenario scenario) {
        this.logDiv(scenario.getKeyword(), scenario.getName(), "scenario");
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.logDiv(scenarioOutline.getKeyword(), scenarioOutline.getName(), "scenarioOutline");
    }

    public void examples(Examples examples) {
    }

    public void step(Step step) {
        this.steps.add(step);
    }

    public void eof() {
    }

    public void syntaxError(String s, String s2, List<String> strings, String s3, Integer integer) {
    }

    public void done() {
        this.steps.clear();
    }

    public void close() {
        this.out.close();
    }

    public void before(Match match, Result result) {
    }

    public void result(Result result) {
        this.logResult(result);
        if ("failed".equals(result.getStatus())) {
            ITestResult tr = Reporter.getCurrentTestResult();
            tr.setThrowable(result.getError());
            tr.setStatus(2);
        } else if (Result.SKIPPED.equals(result)) {
            ITestResult tr = Reporter.getCurrentTestResult();
            tr.setThrowable(result.getError());
            tr.setStatus(3);
        } else if (Result.UNDEFINED.equals(result)) {
            ITestResult tr = Reporter.getCurrentTestResult();
            tr.setThrowable(result.getError());
            tr.setStatus(2);
        }
    }

    private void logResult(Result result) {
        String timing = this.computeTiming(result);
        Step step = this.steps.isEmpty() ? new Step(null, "MISMATCH BETWEEN STEPS AND RESULTS", "", Integer.valueOf(0), null, null) : this.steps.pop();
        String format = "%s %s (%s%s)";
        String message = String.format(format, step.getKeyword(), step.getName(), result.getStatus(), timing);
        this.logDiv(message, "result");
    }

    private String computeTiming(Result result) {
        String timing = "";
        if (result.getDuration() != null) {
            int duration = Math.round(result.getDuration() / 1000000000L);
            timing = " : " + duration + "s";
        }
        return timing;
    }

    public void after(Match match, Result result) {
    }

    public void write(String s) {
    }

    public void match(Match match) {
    }

    public void embedding(String s, byte[] bytes) {
    }

    private void logDiv(String message, String cssClassName) {
        String format = "<div \"%s\">%s</div>";
        String output = String.format(format, cssClassName, Utils.htmlEscape((String)message));
        Reporter.log((String)output);
    }

    private void logDiv(String message, String message2, String cssClassName) {
        this.logDiv(message + ": " + message2, cssClassName);
    }
}

