/*
 * Decompiled with CFR 0.152.
 */
package gherkin;

import gherkin.formatter.PrettyFormatter;
import gherkin.formatter.model.Comment;
import gherkin.formatter.model.DataTableRow;
import gherkin.lexer.Lexer;
import gherkin.lexer.Listener;
import gherkin.util.FixJava;
import gherkin.util.Mapper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;

public class I18n {
    private static final List<String> FEATURE_ELEMENT_KEYWORD_KEYS = Arrays.asList("feature", "background", "scenario", "scenario_outline", "examples");
    private static final List<String> STEP_KEYWORD_KEYS = Arrays.asList("given", "when", "then", "and", "but");
    private static final List<String> KEYWORD_KEYS = new ArrayList<String>();
    private static final Mapper QUOTE_MAPPER;
    private static final Mapper CODE_KEYWORD_MAPPER;
    private final String isoCode;
    private final Locale locale;
    private final Map<String, List<String>> keywords;

    public static String codeKeywordFor(String keyword) {
        return keyword.replaceAll("[\\s',!]", "");
    }

    public I18n(String isoCode) {
        this.isoCode = isoCode;
        this.locale = this.localeFor(this.isoCode);
        this.keywords = new HashMap<String, List<String>>();
        this.populateKeywords();
    }

    private void populateKeywords() {
        ResourceBundle keywordBundle = ResourceBundle.getBundle("gherkin.I18nKeywords", this.locale);
        Enumeration<String> keys = keywordBundle.getKeys();
        while (keys.hasMoreElements()) {
            ArrayList<String> keywordList = new ArrayList<String>();
            String key = keys.nextElement();
            String value = keywordBundle.getString(key);
            keywordList.addAll(Arrays.asList(value.split("\\|")));
            this.keywords.put(key, Collections.unmodifiableList(keywordList));
        }
    }

    public String getIsoCode() {
        return this.isoCode;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getUnderscoredIsoCode() {
        return this.getIsoCode().replaceAll("[\\s-]", "_").toLowerCase();
    }

    public Lexer lexer(Listener listener) {
        String qualifiedI18nLexerClassName = "gherkin.lexer.i18n." + this.localeName().toUpperCase();
        try {
            Class<?> delegateClass = this.getClass().getClassLoader().loadClass(qualifiedI18nLexerClassName);
            return (Lexer)delegateClass.getConstructor(Listener.class).newInstance(listener);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't load lexer class: " + qualifiedI18nLexerClassName, e);
        }
    }

    private String localeName() {
        return this.locale.toString().replaceAll("^iw", "he").replaceAll("^in", "id");
    }

    public List<String> keywords(String key) {
        if (!this.keywords.containsKey(key)) {
            throw new RuntimeException("No such key: " + key + ". Available keys: " + this.keywords.keySet());
        }
        return this.keywords.get(key);
    }

    public List<String> getCodeKeywords() {
        List<String> result = FixJava.map(this.getStepKeywords(), CODE_KEYWORD_MAPPER);
        result.remove("*");
        return result;
    }

    public List<String> getStepKeywords() {
        TreeSet result = new TreeSet();
        for (String keyword : STEP_KEYWORD_KEYS) {
            result.addAll(this.keywords.get(keyword));
        }
        return new ArrayList<String>(result);
    }

    public String getKeywordTable() {
        StringWriter writer = new StringWriter();
        PrettyFormatter pf = new PrettyFormatter(writer, true, false);
        ArrayList<DataTableRow> table = new ArrayList<DataTableRow>();
        for (String key : KEYWORD_KEYS) {
            List<String> cells = Arrays.asList(key, FixJava.join(FixJava.map(this.keywords(key), QUOTE_MAPPER), ", "));
            table.add(new DataTableRow(Collections.<Comment>emptyList(), cells, -1));
        }
        for (String key : STEP_KEYWORD_KEYS) {
            ArrayList codeKeywordList = new ArrayList(this.keywords.get(key));
            codeKeywordList.remove("* ");
            String codeKeywords = FixJava.join(FixJava.map(FixJava.map(codeKeywordList, CODE_KEYWORD_MAPPER), QUOTE_MAPPER), ", ");
            List<String> cells = Arrays.asList(key + " (code)", codeKeywords);
            table.add(new DataTableRow(Collections.<Comment>emptyList(), cells, -1));
        }
        pf.table(table);
        return writer.getBuffer().toString();
    }

    private Locale localeFor(String isoString) {
        String[] languageAndCountry = isoString.split("-");
        if (languageAndCountry.length == 1) {
            return new Locale(isoString);
        }
        return new Locale(languageAndCountry[0], languageAndCountry[1]);
    }

    static {
        KEYWORD_KEYS.addAll(FEATURE_ELEMENT_KEYWORD_KEYS);
        KEYWORD_KEYS.addAll(STEP_KEYWORD_KEYS);
        QUOTE_MAPPER = new Mapper(){

            public String map(Object o) {
                return '\"' + (String)o + '\"';
            }
        };
        CODE_KEYWORD_MAPPER = new Mapper(){

            public String map(Object keyword) {
                return I18n.codeKeywordFor((String)keyword);
            }
        };
    }
}

