/*
 * Decompiled with CFR 0.152.
 */
package gherkin.formatter;

import gherkin.deps.net.iharder.Base64;
import gherkin.deps.org.json.simple.JSONValue;
import gherkin.formatter.Formatter;
import gherkin.formatter.NiceAppendable;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONFormatter
implements Reporter,
Formatter {
    private final List<Map<Object, Object>> featureMaps = new ArrayList<Map<Object, Object>>();
    private final NiceAppendable out;
    private Map<Object, Object> featureMap;
    private int stepIndex = 0;
    private String uri;

    public JSONFormatter(Appendable out) {
        this.out = new NiceAppendable(out);
    }

    @Override
    public void close() {
        this.out.append(JSONValue.toJSONString(this.featureMaps));
        this.out.close();
    }

    @Override
    public void uri(String uri) {
        this.uri = uri;
    }

    @Override
    public void feature(Feature feature) {
        this.featureMap = feature.toMap();
        this.featureMap.put("uri", this.uri);
        this.featureMaps.add(this.featureMap);
    }

    @Override
    public void background(Background background) {
        this.getFeatureElements().add(background.toMap());
        this.stepIndex = 0;
    }

    @Override
    public void scenario(Scenario scenario) {
        this.getFeatureElements().add(scenario.toMap());
        this.stepIndex = 0;
    }

    @Override
    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.getFeatureElements().add(scenarioOutline.toMap());
        this.stepIndex = 0;
    }

    @Override
    public void examples(Examples examples) {
        this.getAllExamples().add(examples.toMap());
    }

    @Override
    public void step(Step step) {
        this.getSteps().add(step.toMap());
    }

    @Override
    public void match(Match match) {
        this.getStepAt(this.stepIndex).put("match", match.toMap());
    }

    @Override
    public void result(Result result) {
        this.getStepAt(this.stepIndex).put("result", result.toMap());
        ++this.stepIndex;
    }

    @Override
    public void embedding(final String mimeType, final byte[] data) {
        HashMap<String, String> embedding = new HashMap<String, String>(){
            {
                this.put("mime_type", mimeType);
                this.put("data", Base64.encodeBytes(data));
            }
        };
        this.getEmbeddings().add(embedding);
    }

    @Override
    public void eof() {
    }

    @Override
    public void syntaxError(String state, String event, List<String> legalEvents, String uri, int line) {
        throw new UnsupportedOperationException();
    }

    private List<Object> getFeatureElements() {
        ArrayList featureElements = (ArrayList)this.featureMap.get("elements");
        if (featureElements == null) {
            featureElements = new ArrayList();
            this.featureMap.put("elements", featureElements);
        }
        return featureElements;
    }

    private Map<Object, List<Object>> getFeatureElement() {
        return (Map)this.getFeatureElements().get(this.getFeatureElements().size() - 1);
    }

    private List<Object> getAllExamples() {
        List<Object> allExamples = this.getFeatureElement().get("examples");
        if (allExamples == null) {
            allExamples = new ArrayList<Object>();
            this.getFeatureElement().put("examples", allExamples);
        }
        return allExamples;
    }

    private List<Object> getSteps() {
        List<Object> steps = this.getFeatureElement().get("steps");
        if (steps == null) {
            steps = new ArrayList<Object>();
            this.getFeatureElement().put("steps", steps);
        }
        return steps;
    }

    private Map<Object, Object> getLastStep() {
        return this.getStepAt(this.getSteps().size() - 1);
    }

    private Map<Object, Object> getStepAt(int index) {
        return (Map)this.getSteps().get(index);
    }

    private List getEmbeddings() {
        ArrayList embeddings = (ArrayList)this.getLastStep().get("embeddings");
        if (embeddings == null) {
            embeddings = new ArrayList();
            this.getLastStep().put("embeddings", embeddings);
        }
        return embeddings;
    }
}

