/*
 * Decompiled with CFR 0.152.
 */
package gherkin.formatter;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Mappable {
    private static final Integer NO_LINE = -1;

    public Map<Object, Object> toMap() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        List<Field> mappableFields = this.getMappableFields();
        for (Field field : mappableFields) {
            Map<Object, Object> value = this.getValue(field);
            if (value != null && Mappable.class.isAssignableFrom(value.getClass())) {
                value = ((Mappable)((Object)value)).toMap();
            }
            if (value != null && List.class.isAssignableFrom(value.getClass())) {
                ArrayList<Map<Object, Object>> mappedValue = new ArrayList<Map<Object, Object>>();
                for (Object o : (List)((Object)value)) {
                    if (Mappable.class.isAssignableFrom(o.getClass())) {
                        mappedValue.add(((Mappable)o).toMap());
                        continue;
                    }
                    mappedValue.add((Map<Object, Object>)o);
                }
                value = mappedValue;
            }
            if (value == null || ((Object)Collections.EMPTY_LIST).equals(value) || NO_LINE.equals(value)) continue;
            map.put(field.getName(), value);
        }
        return map;
    }

    private Object getValue(Field field) {
        try {
            field.setAccessible(true);
            return field.get(this);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Field> getMappableFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = this.getClass(); c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!this.isMappable(field)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    private boolean isMappable(Field field) {
        boolean transientField = Modifier.isTransient(field.getModifiers());
        boolean instanceField = !Modifier.isStatic(field.getModifiers());
        boolean mappableType = this.isMappableType(field.getType(), field.getGenericType());
        return !transientField && instanceField && mappableType;
    }

    private boolean isMappableType(Class type, Type genericType) {
        return String.class.equals((Object)type) || type.isPrimitive() || Number.class.isAssignableFrom(type) || Mappable.class.isAssignableFrom(type) || genericType != null && Collection.class.isAssignableFrom(type) && this.isMappableCollection(genericType);
    }

    private boolean isMappableCollection(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            Type[] parameters = ((ParameterizedType)genericType).getActualTypeArguments();
            return parameters[0] instanceof Class && this.isMappableType((Class)parameters[0], null);
        }
        return false;
    }
}

