/*
 * Decompiled with CFR 0.152.
 */
package gherkin.formatter.model;

import gherkin.formatter.Mappable;
import gherkin.formatter.Reporter;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Result
extends Mappable {
    private final String status;
    private final Long duration;
    private final String error_message;
    private final Throwable error;
    public static final Result SKIPPED = new Result("skipped", null, null);
    public static final Result UNDEFINED = new Result("undefined", null, null);
    public static final String PASSED = "passed";
    public static final String FAILED = "failed";

    public Result(String status, Long duration, Throwable error, Object dummy) {
        this.status = status;
        this.duration = duration;
        this.error_message = null;
        this.error = error;
    }

    public Result(String status, Long duration, String errorMessage) {
        this.status = status;
        this.duration = duration;
        this.error_message = errorMessage;
        this.error = null;
    }

    public String getStatus() {
        return this.status;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Throwable getError() {
        return this.error;
    }

    public String getErrorMessage() {
        if (this.error_message != null) {
            return this.error_message;
        }
        if (this.error != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.error.printStackTrace(printWriter);
            return stringWriter.getBuffer().toString();
        }
        return null;
    }

    public void replay(Reporter reporter) {
        reporter.result(this);
    }
}

