/*
 * Decompiled with CFR 0.152.
 */
package gherkin;

import gherkin.deps.net.iharder.Base64;
import gherkin.deps.org.json.simple.JSONArray;
import gherkin.deps.org.json.simple.JSONObject;
import gherkin.deps.org.json.simple.JSONValue;
import gherkin.formatter.Argument;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.BasicStatement;
import gherkin.formatter.model.Comment;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.ExamplesTableRow;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class JSONParser {
    private final Reporter reporter;
    private final Formatter formatter;

    public JSONParser(Reporter reporter, Formatter formatter) {
        this.reporter = reporter;
        this.formatter = formatter;
    }

    public void parse(String src) {
        JSONArray featureHashes = (JSONArray)JSONValue.parse(src);
        for (Object f : featureHashes) {
            JSONObject o = (JSONObject)f;
            this.formatter.uri(this.getString(o, "uri"));
            new Feature(this.comments(o), this.tags(o), this.keyword(o), this.name(o), this.description(o), this.line(o), this.id(o)).replay(this.formatter);
            for (Object e : this.getList(o, "elements")) {
                JSONObject featureElement = (JSONObject)e;
                this.featureElement(featureElement).replay(this.formatter);
                for (Object s : this.getList(featureElement, "steps")) {
                    JSONObject step = (JSONObject)s;
                    this.step(step);
                }
                for (Object s : this.getList(featureElement, "examples")) {
                    JSONObject eo = (JSONObject)s;
                    new Examples(this.comments(eo), this.tags(eo), this.keyword(eo), this.name(eo), this.description(eo), this.line(eo), this.id(eo), this.examplesTableRows(this.getList(eo, "rows"))).replay(this.formatter);
                }
            }
            this.formatter.eof();
        }
    }

    private BasicStatement featureElement(JSONObject o) {
        String type = (String)o.get("type");
        if (type.equals("background")) {
            return new Background(this.comments(o), this.keyword(o), this.name(o), this.description(o), this.line(o));
        }
        if (type.equals("scenario")) {
            return new Scenario(this.comments(o), this.tags(o), this.keyword(o), this.name(o), this.description(o), this.line(o), this.id(o));
        }
        if (type.equals("scenario_outline")) {
            return new ScenarioOutline(this.comments(o), this.tags(o), this.keyword(o), this.name(o), this.description(o), this.line(o), this.id(o));
        }
        return null;
    }

    private void step(JSONObject o) {
        List<DataTableRow> rows = null;
        if (o.containsKey("rows")) {
            rows = this.dataTableRows(this.getList(o, "rows"));
        }
        DocString docString = null;
        if (o.containsKey("doc_string")) {
            Map ds = (Map)o.get("doc_string");
            docString = new DocString(this.getString(ds, "content_type"), this.getString(ds, "value"), this.getInt(ds, "line"));
        }
        Step step = new Step(this.comments(o), this.keyword(o), this.name(o), this.line(o), rows, docString);
        step.replay(this.formatter);
        if (o.containsKey("match")) {
            Map m = (Map)o.get("match");
            new Match(this.arguments(m), this.location(m)).replay(this.reporter);
        }
        if (o.containsKey("result")) {
            Map r = (Map)o.get("result");
            new Result(this.status(r), this.duration(r), this.errorMessage(r)).replay(this.reporter);
        }
        if (o.containsKey("embeddings")) {
            List es = (List)o.get("embeddings");
            for (Map e : es) {
                try {
                    this.reporter.embedding(this.getString(e, "mime_type"), Base64.decode(this.getString(e, "data")));
                }
                catch (IOException ex) {
                    throw new RuntimeException("Couldn't decode data", ex);
                }
            }
        }
    }

    private List<DataTableRow> dataTableRows(List o) {
        ArrayList<DataTableRow> rows = new ArrayList<DataTableRow>(o.size());
        for (Object e : o) {
            Map row = (Map)e;
            rows.add(new DataTableRow(this.comments(row), this.getList(row, "cells"), this.getInt(row, "line")));
        }
        return rows;
    }

    private List<ExamplesTableRow> examplesTableRows(List o) {
        ArrayList<ExamplesTableRow> rows = new ArrayList<ExamplesTableRow>(o.size());
        for (Object e : o) {
            Map row = (Map)e;
            rows.add(new ExamplesTableRow(this.comments(row), this.getList(row, "cells"), this.getInt(row, "line"), this.id(row)));
        }
        return rows;
    }

    private List<Comment> comments(Map o) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        if (o.containsKey("comments")) {
            for (Object e : (List)o.get("comments")) {
                Map map = (Map)e;
                comments.add(new Comment(this.getString(map, "value"), this.getInt(map, "line")));
            }
        }
        return comments;
    }

    private List<Tag> tags(Map o) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (o.containsKey("tags")) {
            for (Object e : (List)o.get("tags")) {
                Map map = (Map)e;
                tags.add(new Tag(this.getString(map, "name"), this.getInt(map, "line")));
            }
        }
        return tags;
    }

    private String keyword(Map o) {
        return this.getString(o, "keyword");
    }

    private String name(Map o) {
        return this.getString(o, "name");
    }

    private String description(Map o) {
        return this.getString(o, "description");
    }

    private int line(Map o) {
        return this.getInt(o, "line");
    }

    private String id(Map o) {
        return this.getString(o, "id");
    }

    private List<Argument> arguments(Map m) {
        List arguments = this.getList(m, "arguments");
        ArrayList<Argument> result = new ArrayList<Argument>();
        for (Object argument : arguments) {
            Map argMap = (Map)argument;
            result.add(new Argument(this.getInt(argMap, "offset"), this.getString(argMap, "val")));
        }
        return result;
    }

    private String location(Map m) {
        return this.getString(m, "location");
    }

    private String status(Map r) {
        return this.getString(r, "status");
    }

    private long duration(Map r) {
        return this.getLong(r, "duration");
    }

    private String errorMessage(Map r) {
        return this.getString(r, "error_message");
    }

    private String getString(Map map, String key) {
        Object string = map.get(key);
        return string == null ? null : (String)string;
    }

    private int getInt(Map map, String key) {
        Object n = map.get(key);
        return n == null ? -1 : ((Number)n).intValue();
    }

    private long getLong(Map map, String key) {
        Object n = map.get(key);
        return n == null ? -1L : ((Number)n).longValue();
    }

    private List getList(Map map, String key) {
        Object list = map.get(key);
        return list == null ? Collections.emptyList() : (List)list;
    }
}

