/*
 * Decompiled with CFR 0.152.
 */
package gherkin.formatter.model;

import gherkin.formatter.Mappable;
import gherkin.formatter.model.CellResult;
import gherkin.formatter.model.Comment;
import gherkin.formatter.model.CommentHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class Row
extends Mappable
implements CommentHolder {
    private final List<Comment> comments;
    private final List<String> cells;
    private final int line;

    public Row(List<Comment> comments, List<String> cells, int line) {
        if (comments == null) {
            throw new NullPointerException("comments");
        }
        if (cells == null) {
            throw new NullPointerException("cells");
        }
        this.comments = comments;
        this.cells = cells;
        this.line = line;
    }

    @Override
    public List<Comment> getComments() {
        return this.comments;
    }

    public List<String> getCells() {
        return this.cells;
    }

    public int getLine() {
        return this.line;
    }

    public List<CellResult> createResults(String status) {
        ArrayList<CellResult> results = new ArrayList<CellResult>();
        for (String cell : this.cells) {
            results.add(new CellResult(status));
        }
        return results;
    }

    public abstract DiffType getDiffType();

    public static enum DiffType {
        NONE,
        DELETE,
        INSERT;

    }
}

