/*
 * Decompiled with CFR 0.152.
 */
package gherkin.formatter.model;

import gherkin.formatter.Formatter;
import gherkin.formatter.model.Comment;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.ExamplesTableRow;
import gherkin.formatter.model.Tag;
import gherkin.formatter.model.TagStatement;
import java.util.ArrayList;
import java.util.List;

public class Examples
extends TagStatement {
    private List<ExamplesTableRow> rows;

    public Examples(List<Comment> comments, List<Tag> tags, String keyword, String name, String description, int line, String id, List<ExamplesTableRow> rows) {
        super(comments, tags, keyword, name, description, line, id);
        this.rows = rows;
    }

    @Override
    public void replay(Formatter formatter) {
        formatter.examples(this);
    }

    public List<ExamplesTableRow> getRows() {
        return this.rows;
    }

    public void setRows(List<ExamplesTableRow> rows) {
        this.rows = rows;
    }

    public static class Builder
    implements gherkin.formatter.model.Builder {
        private final List<Comment> comments;
        private final List<Tag> tags;
        private final String keyword;
        private final String name;
        private final String description;
        private final int line;
        private final String id;
        private List<ExamplesTableRow> rows;

        public Builder(List<Comment> comments, List<Tag> tags, String keyword, String name, String description, int line, String id) {
            this.comments = comments;
            this.tags = tags;
            this.keyword = keyword;
            this.name = name;
            this.description = description;
            this.line = line;
            this.id = id;
        }

        @Override
        public void row(List<Comment> comments, List<String> cells, int line, String id) {
            if (this.rows == null) {
                this.rows = new ArrayList<ExamplesTableRow>();
            }
            this.rows.add(new ExamplesTableRow(comments, cells, line, id));
        }

        @Override
        public void replay(Formatter formatter) {
            new Examples(this.comments, this.tags, this.keyword, this.name, this.description, this.line, this.id, this.rows).replay(formatter);
        }

        @Override
        public void docString(DocString docString) {
            throw new IllegalStateException("Can't have DocString in Examples");
        }
    }
}

