/*
 * Decompiled with CFR 0.152.
 */
package gherkin;

import gherkin.GherkinLineSpan;
import gherkin.IGherkinLine;
import gherkin.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class GherkinLine
implements IGherkinLine {
    private final String lineText;
    private final int lineNumber;
    private final String trimmedLineText;

    public GherkinLine(String lineText, int lineNumber) {
        this.lineText = lineText;
        this.lineNumber = lineNumber;
        this.trimmedLineText = StringUtils.ltrim(lineText);
    }

    @Override
    public Integer indent() {
        return this.lineText.length() - this.trimmedLineText.length();
    }

    @Override
    public void detach() {
    }

    @Override
    public String getLineText(int indentToRemove) {
        if (indentToRemove < 0 || indentToRemove > this.indent()) {
            return this.trimmedLineText;
        }
        return this.lineText.substring(indentToRemove);
    }

    @Override
    public boolean isEmpty() {
        return this.trimmedLineText.length() == 0;
    }

    @Override
    public boolean startsWith(String prefix) {
        return this.trimmedLineText.startsWith(prefix);
    }

    @Override
    public String getRestTrimmed(int length) {
        return this.trimmedLineText.substring(length).trim();
    }

    @Override
    public List<GherkinLineSpan> getTags() {
        return this.getSpans("\\s+");
    }

    @Override
    public boolean startsWithTitleKeyword(String text) {
        int textLength = text.length();
        return this.trimmedLineText.length() > textLength && this.trimmedLineText.startsWith(text) && this.trimmedLineText.substring(textLength, textLength + ":".length()).equals(":");
    }

    @Override
    public List<GherkinLineSpan> getTableCells() {
        return this.getSpans("\\s*\\|\\s*");
    }

    private List<GherkinLineSpan> getSpans(String delimiter) {
        ArrayList<GherkinLineSpan> lineSpans = new ArrayList<GherkinLineSpan>();
        Scanner scanner = new Scanner(this.trimmedLineText).useDelimiter(delimiter);
        while (scanner.hasNext()) {
            String cell = scanner.next();
            int column = scanner.match().start() + this.indent() + 1;
            lineSpans.add(new GherkinLineSpan(column, cell));
        }
        return lineSpans;
    }
}

