/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.datasets.enron;

import info.debatty.java.datasets.enron.Email;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.MessagingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dataset
extends info.debatty.java.datasets.Dataset<Email> {
    private String directory;

    public Dataset(String directory) {
        this.directory = directory;
    }

    @Override
    public Iterator<Email> iterator() {
        return new EnronIterator(this.directory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnronIterator
    implements Iterator<Email> {
        private static final int BUFFER_SIZE = 10;
        private final Stack<File> directories = new Stack();
        private final LinkedList<Email> available_emails = new LinkedList();
        private final LinkedList<File> available_files = new LinkedList();
        private final String root;

        public EnronIterator(String directory) {
            this.root = directory;
            this.directories.push(new File(directory));
            this.readNextFiles();
            this.readNextPages();
        }

        @Override
        public boolean hasNext() {
            return !this.available_emails.isEmpty();
        }

        @Override
        public Email next() {
            Email current = this.available_emails.removeFirst();
            if (this.available_emails.isEmpty()) {
                this.readNextPages();
            }
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported!");
        }

        private void readNextPages() {
            while (this.available_emails.size() < 10) {
                if (this.available_files.isEmpty()) {
                    return;
                }
                File next_file = this.available_files.poll();
                try {
                    this.available_emails.add(new Email(this.readFile(next_file.getPath()), next_file.getParent().substring(this.root.length() + 1)));
                }
                catch (IOException ex) {
                    Logger.getLogger(Dataset.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (MessagingException ex) {
                    Logger.getLogger(Dataset.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (!this.available_files.isEmpty()) continue;
                this.readNextFiles();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readFile(String file) throws IOException {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            StringBuilder string_builder = new StringBuilder();
            String ls = System.getProperty("line.separator");
            try {
                while ((line = reader.readLine()) != null) {
                    string_builder.append(line);
                    string_builder.append(ls);
                }
                String string = string_builder.toString();
                return string;
            }
            finally {
                reader.close();
            }
        }

        private void readNextFiles() {
            while (this.available_files.isEmpty()) {
                if (this.directories.empty()) {
                    return;
                }
                File current_folder = this.directories.pop();
                for (File file : current_folder.listFiles()) {
                    if (file.isDirectory()) {
                        this.directories.push(file);
                        continue;
                    }
                    this.available_files.add(file);
                }
            }
        }
    }
}

