/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.datasets.enron;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.mail.util.MimeMessageParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Email {
    private String raw;
    private final MimeMessageParser parser;
    private final String mailbox;
    private final String user;

    Email(String raw, String mailbox) throws MessagingException {
        this.raw = raw;
        String[] strings = mailbox.split(File.separator, 2);
        this.user = strings[0];
        this.mailbox = strings[1];
        Session s = Session.getDefaultInstance((Properties)new Properties());
        ByteArrayInputStream is = new ByteArrayInputStream(raw.getBytes());
        MimeMessage message = new MimeMessage(s, (InputStream)is);
        this.parser = new MimeMessageParser(message);
    }

    public String getUser() {
        return this.user;
    }

    public String getFrom() throws Exception {
        return this.parser.getFrom();
    }

    public String getMailbox() {
        return this.mailbox;
    }

    private static List<String> addressToString(List<Address> addresses) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Address address : addresses) {
            strings.add(address.toString());
        }
        return strings;
    }

    public List<String> getTo() throws Exception {
        return Email.addressToString(this.parser.getTo());
    }

    public List<String> getCc() throws Exception {
        return Email.addressToString(this.parser.getCc());
    }

    public List<String> getBcc() throws Exception {
        return Email.addressToString(this.parser.getBcc());
    }

    public String getPlainContent() {
        return this.parser.getPlainContent();
    }

    public String getSubject() throws Exception {
        return this.parser.getSubject();
    }

    public String getRaw() {
        return this.raw;
    }
}

