/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.datasets.wikipedia;

import info.debatty.java.datasets.wikipedia.Page;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dataset
extends info.debatty.java.datasets.Dataset<Page> {
    private String directory;

    public Dataset(String directory) {
        this.directory = directory;
    }

    @Override
    public Iterator<Page> iterator() {
        return new WikipediaIterator(this.directory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WikipediaIterator
    implements Iterator<Page> {
        private static final int BUFFER_SIZE = 10;
        private final Stack<File> directories = new Stack();
        private final LinkedList<Page> available_pages = new LinkedList();
        private final LinkedList<File> available_files = new LinkedList();

        public WikipediaIterator(String directory) {
            this.directories.push(new File(directory));
            this.readNextFiles();
            this.readNextPages();
        }

        @Override
        public boolean hasNext() {
            return !this.available_pages.isEmpty();
        }

        @Override
        public Page next() {
            Page current = this.available_pages.removeFirst();
            if (this.available_pages.isEmpty()) {
                this.readNextPages();
            }
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported!");
        }

        private void readNextPages() {
            while (this.available_pages.size() < 10) {
                if (this.available_files.isEmpty()) {
                    return;
                }
                File next_file = this.available_files.poll();
                try {
                    this.available_pages.add(new Page(this.readFile(next_file.getPath())));
                }
                catch (IOException ex) {
                    Logger.getLogger(Dataset.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (!this.available_files.isEmpty()) continue;
                this.readNextFiles();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readFile(String file) throws IOException {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            StringBuilder stringBuilder = new StringBuilder();
            String ls = System.getProperty("line.separator");
            try {
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line);
                    stringBuilder.append(ls);
                }
                String string = stringBuilder.toString();
                return string;
            }
            finally {
                reader.close();
            }
        }

        private void readNextFiles() {
            while (this.available_files.isEmpty()) {
                if (this.directories.empty()) {
                    return;
                }
                File current_folder = this.directories.pop();
                for (File file : current_folder.listFiles()) {
                    if (file.getName().endsWith(".html")) {
                        this.available_files.add(file);
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    this.directories.push(file);
                }
            }
        }
    }
}

