/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.datasets.dblp;

import info.debatty.java.datasets.dblp.Publication;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DblpIterator
implements Iterator<Publication> {
    private static final int BUFFER_SIZE = 20;
    private static final String[] publication_types = new String[]{"article", "inproceedings", "incollection"};
    XMLEventReader xmlEventReader;
    LinkedList<Publication> next_publications = new LinkedList();
    private boolean in_publication = false;

    private static boolean in_publication_types(String localPart) {
        return DblpIterator.in_array(publication_types, localPart);
    }

    private static boolean in_array(String[] haystack, String needle) {
        for (String string : haystack) {
            if (!string.equals(needle)) continue;
            return true;
        }
        return false;
    }

    DblpIterator(String file) {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        try {
            this.xmlEventReader = xmlInputFactory.createXMLEventReader(new FileInputStream(file));
        }
        catch (FileNotFoundException ex) {
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(DblpIterator.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            this.readNext();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(DblpIterator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void readNext() throws XMLStreamException {
        Publication publication = new Publication();
        while (this.xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
            if (xmlEvent.isStartElement()) {
                StartElement startElement = xmlEvent.asStartElement();
                if (DblpIterator.in_publication_types(startElement.getName().getLocalPart())) {
                    publication = new Publication();
                    publication.type = startElement.getName().getLocalPart();
                    this.in_publication = true;
                    continue;
                }
                if (this.in_publication && startElement.getName().getLocalPart().equals("title")) {
                    xmlEvent = this.xmlEventReader.nextEvent();
                    publication.title = xmlEvent.toString();
                    continue;
                }
            }
            if (!xmlEvent.isEndElement() || !DblpIterator.in_publication_types(xmlEvent.asEndElement().getName().getLocalPart())) continue;
            this.next_publications.add(publication);
            this.in_publication = false;
            if (this.next_publications.size() < 20) continue;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        return !this.next_publications.isEmpty();
    }

    @Override
    public Publication next() {
        Publication pub = this.next_publications.pop();
        if (this.next_publications.isEmpty()) {
            try {
                this.readNext();
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(DblpIterator.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return pub;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

