/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.datasets.enron;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.mail.util.MimeMessageParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Email
implements Serializable {
    private final String raw;
    private final String mailbox;
    private final String user;
    private final String from;
    private final List<String> to;
    private final List<String> cc;
    private final List<String> bcc;
    private final String message_id;
    private final String subject;
    private final String content;

    Email(String raw, String mailbox) throws MessagingException, Exception {
        this.raw = raw;
        String[] strings = mailbox.split(File.separator, 2);
        this.user = strings[0];
        this.mailbox = strings[1];
        Session s = Session.getDefaultInstance((Properties)new Properties());
        ByteArrayInputStream is = new ByteArrayInputStream(raw.getBytes());
        MimeMessage message = new MimeMessage(s, (InputStream)is);
        MimeMessageParser parser = new MimeMessageParser(message);
        this.from = parser.getFrom();
        this.to = Email.addressToString(parser.getTo());
        this.cc = Email.addressToString(parser.getCc());
        this.bcc = Email.addressToString(parser.getBcc());
        this.subject = parser.getSubject();
        this.content = parser.getPlainContent();
        this.message_id = parser.getMimeMessage().getMessageID();
    }

    public String getUser() {
        return this.user;
    }

    public String getFrom() throws Exception {
        return this.from;
    }

    public String getMailbox() {
        return this.mailbox;
    }

    private static List<String> addressToString(List<Address> addresses) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Address address : addresses) {
            strings.add(address.toString());
        }
        return strings;
    }

    public List<String> getTo() throws Exception {
        return this.to;
    }

    public List<String> getCc() {
        return this.cc;
    }

    public String getMessageID() {
        return this.message_id;
    }

    public List<String> getBcc() {
        return this.bcc;
    }

    public String getContent() {
        return this.content;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getRaw() {
        return this.raw;
    }

    public boolean equals(Object other) {
        Email other_email = (Email)other;
        return other_email.message_id.equals(this.message_id);
    }

    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + (this.message_id != null ? this.message_id.hashCode() : 0);
        return hash;
    }
}

