/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.datasets.gaussian;

import info.debatty.java.datasets.gaussian.Center;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dataset
extends info.debatty.java.datasets.Dataset<Double[]> {
    private final ArrayList<Center> centers = new ArrayList();

    public final void addCenter(Center center) {
        this.centers.add(center);
    }

    @Override
    public final Iterator<Double[]> iterator() {
        return new GaussianIterator(this.centers);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GaussianIterator
    implements Iterator<Double[]> {
        private final Random rand;
        private final int dimension;
        private final Center[] lookup_table;
        private int total_weight;

        private GaussianIterator(ArrayList<Center> centers) {
            this.dimension = centers.get(0).getDimension();
            this.rand = new Random();
            this.total_weight = 0;
            for (Center center : centers) {
                this.total_weight += center.getWeight();
            }
            this.lookup_table = new Center[this.total_weight];
            int i = 0;
            for (Center center : centers) {
                for (int j = 0; j < center.getWeight(); ++j) {
                    this.lookup_table[i] = center;
                    ++i;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public Double[] next() {
            Center center = this.lookup_table[this.rand.nextInt(this.total_weight)];
            Double[] point = new Double[this.dimension];
            for (int i = 0; i < this.dimension; ++i) {
                point[i] = center.getCenter(i) + this.rand.nextGaussian() * center.getDeviation(i);
            }
            return point;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported!");
        }
    }
}

