/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.datasets.sift;

import ij.IJ;
import ij.ImagePlus;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import info.debatty.java.datasets.sift.SiftDescriptor;
import info.debatty.java.datasets.sift.SiftDetector;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dataset
extends info.debatty.java.datasets.Dataset<SiftDescriptor> {
    private final String directory;

    public Dataset(String directory) {
        this.directory = directory;
    }

    @Override
    public final Iterator<SiftDescriptor> iterator() {
        return new SiftIterator(this.directory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SiftIterator
    implements Iterator<SiftDescriptor> {
        private static final int BUFFER_SIZE = 10;
        private final Stack<File> directories = new Stack();
        private final LinkedList<SiftDescriptor> available_descriptors = new LinkedList();
        private final LinkedList<File> available_files = new LinkedList();

        SiftIterator(String directory) {
            this.directories.push(new File(directory));
            this.readNextFiles();
            this.readNextPages();
        }

        @Override
        public boolean hasNext() {
            return !this.available_descriptors.isEmpty();
        }

        @Override
        public SiftDescriptor next() {
            SiftDescriptor current = this.available_descriptors.removeFirst();
            if (this.available_descriptors.isEmpty()) {
                this.readNextPages();
            }
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported!");
        }

        private void readNextPages() {
            while (this.available_descriptors.size() < 10) {
                if (this.available_files.isEmpty()) {
                    return;
                }
                File next_file = this.available_files.poll();
                ImagePlus image = IJ.openImage((String)next_file.getPath());
                ImageProcessor processor = image.getProcessor();
                FloatProcessor fp = new FloatProcessor(processor.getFloatArray());
                SiftDetector detector = new SiftDetector(fp);
                this.available_descriptors.add(new SiftDescriptor(next_file.getPath(), detector.getSiftFeatures()));
                if (!this.available_files.isEmpty()) continue;
                this.readNextFiles();
            }
        }

        private void readNextFiles() {
            while (this.available_files.isEmpty()) {
                if (this.directories.empty()) {
                    return;
                }
                File current_folder = this.directories.pop();
                for (File file : current_folder.listFiles()) {
                    if (file.getName().toLowerCase().endsWith("jpg") || file.getName().toLowerCase().endsWith("png")) {
                        this.available_files.add(file);
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    this.directories.push(file);
                }
            }
        }
    }
}

