/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.datasets.sift;

import ij.IJ;
import ij.plugin.filter.Convolver;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

class GaussianFilter {
    static final double kernelSizeFactor = 3.5;
    private float[] kernel1D;

    public GaussianFilter(double sigma) {
        this.kernel1D = GaussianFilter.makeGaussKernel1d(sigma);
    }

    public void applyTo(FloatProcessor fp) {
        Convolver Conv = new Convolver();
        Conv.setNormalize(true);
        Conv.convolve((ImageProcessor)fp, this.kernel1D, 1, this.kernel1D.length);
        Conv.convolve((ImageProcessor)fp, this.kernel1D, this.kernel1D.length, 1);
    }

    public static float[] makeGaussKernel1d(double sigma) {
        int rad = (int)(3.5 * sigma);
        if (rad < 1) {
            rad = 1;
        }
        int size = rad + rad + 1;
        float[] kernel = new float[size];
        double sigma2 = sigma * sigma;
        double scale = 1.0 / (Math.sqrt(Math.PI * 2) * sigma);
        for (int i = 0; i < size; ++i) {
            double x = rad - i;
            kernel[i] = (float)(scale * Math.exp(-0.5 * (x * x) / sigma2));
        }
        return kernel;
    }

    static float[][] makeGaussKernel2d(double sigma) {
        int i;
        int rad = (int)(3.5 * sigma);
        int size = rad + rad + 1;
        float[][] kernel = new float[size][size];
        double sigma2 = sigma * sigma;
        double scale = 1.0 / (Math.PI * 2 * sigma * sigma);
        double sum = 0.0;
        for (i = 0; i < size; ++i) {
            double x = rad - i;
            for (int j = 0; j < size; ++j) {
                double y = rad - j;
                kernel[i][j] = (float)(scale * Math.exp(-0.5 * (x * x + y * y) / sigma2));
                sum += (double)kernel[i][j];
            }
        }
        for (i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                kernel[i][j] = (float)((double)kernel[i][j] / sum);
            }
        }
        return kernel;
    }

    void printKernel(float[] kernel) {
        System.out.println("****** Gaussian kernel ******* ");
        for (int i = 0; i < kernel.length; ++i) {
            System.out.println(i + ": " + kernel[i]);
        }
    }

    void printKernel(float[][] kernel) {
        System.out.println("****** Gaussian kernel ******* ");
        for (int i = 0; i < kernel.length; ++i) {
            for (int j = 0; j < kernel[i].length; ++j) {
                System.out.print(" " + kernel[i][j]);
            }
            System.out.println();
        }
    }

    void printKernel(float[] kernel, String title) {
        IJ.log((String)("****** " + title + " ******* "));
        for (int i = 0; i < kernel.length; ++i) {
            IJ.log((String)(i + ": " + kernel[i]));
        }
    }

    static float sumKernel(float[] kernel) {
        float sum = 0.0f;
        for (int i = 0; i < kernel.length; ++i) {
            sum += kernel[i];
        }
        return sum;
    }

    static float sumKernel(float[][] kernel) {
        float sum = 0.0f;
        for (float[] kernel1 : kernel) {
            for (int j = 0; j < kernel1.length; ++j) {
                sum += kernel1[j];
            }
        }
        return sum;
    }
}

