/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.datasets.sift;

import info.debatty.java.datasets.sift.ScaleLevel;
import info.debatty.java.datasets.sift.ScaleOctave;

class GaussianOctave
extends ScaleOctave {
    GaussianOctave(int p, int Q, ScaleLevel Gbot, int botIndex, int topIndex, double sigma_0) {
        super(p, Q, Gbot, botIndex, topIndex);
        this.sigma_0 = sigma_0;
        double sigmaA_bot = this.getAbsoluteScale(p, botIndex);
        Gbot.setAbsoluteScale(sigmaA_bot);
        for (int q = botIndex + 1; q <= topIndex; ++q) {
            double sigmaA_q = this.getAbsoluteScale(p, q);
            double sigmaR_q = sigma_0 * Math.sqrt(Math.pow(2.0, 2.0 * (double)q / (double)Q) - Math.pow(2.0, -2.0 / (double)Q));
            ScaleLevel G_pq = Gbot.duplicate();
            G_pq.filterGaussian(sigmaR_q);
            G_pq.setAbsoluteScale(sigmaA_q);
            this.setLevel(q, G_pq);
        }
    }
}

