/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.datasets.sift;

import ij.process.FloatProcessor;
import info.debatty.java.datasets.sift.GaussianOctave;
import info.debatty.java.datasets.sift.HierarchicalScaleSpace;
import info.debatty.java.datasets.sift.ScaleLevel;

class GaussianScaleSpace
extends HierarchicalScaleSpace {
    public GaussianScaleSpace(FloatProcessor fp, double sigma_s, double sigma_0, int P, int Q, int botLevel, int topLevel) {
        super(P, Q, sigma_s, sigma_0, botLevel, topLevel);
        this.build(fp);
    }

    private final void build(FloatProcessor fp) {
        double scale_b = this.getAbsoluteScale(0, -1.0f);
        double sigma_b = this.getRelativeScale(this.sigma_s, scale_b);
        ScaleLevel Ginit = new ScaleLevel(fp, this.sigma_s);
        Ginit.filterGaussian(sigma_b);
        Ginit.setAbsoluteScale(scale_b);
        this.octaves[0] = new GaussianOctave(0, this.Q, Ginit, this.botLevel, this.topLevel, this.sigma_0);
        for (int p = 1; p < this.P; ++p) {
            ScaleLevel Gbase = this.octaves[p - 1].getLevel(this.Q - 1).decimate();
            this.octaves[p] = new GaussianOctave(p, this.Q, Gbase, this.botLevel, this.topLevel, this.sigma_0);
        }
    }
}

