/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.datasets.sift;

import ij.IJ;
import info.debatty.java.datasets.sift.ScaleLevel;
import info.debatty.java.datasets.sift.ScaleOctave;

abstract class HierarchicalScaleSpace {
    final int P;
    final int Q;
    final double sigma_s;
    final double sigma_0;
    final int botLevel;
    final int topLevel;
    final ScaleOctave[] octaves;

    HierarchicalScaleSpace(int P, int Q, double sigma_s, double sigma_0, int botLevel, int topLevel) {
        this.Q = Q;
        this.P = P;
        this.sigma_s = sigma_s;
        this.sigma_0 = sigma_0;
        this.botLevel = botLevel;
        this.topLevel = topLevel;
        this.octaves = new ScaleOctave[P];
    }

    public int getP() {
        return this.P;
    }

    public int getQ() {
        return this.Q;
    }

    public double getSigma_s() {
        return this.sigma_s;
    }

    public double getSigma_0() {
        return this.sigma_0;
    }

    public ScaleOctave getOctave(int p) {
        return this.octaves[p];
    }

    public ScaleLevel getScaleLevel(int p, int q) {
        return this.getOctave(p).getLevel(q);
    }

    public int getScaleIndex(int p, int q) {
        int m = this.Q * p + q;
        return m;
    }

    public float getScaleIndexFloat(float p, float q) {
        float m = (float)this.Q * p + q;
        return m;
    }

    public double getAbsoluteScale(int p, float q) {
        double m = (float)(this.Q * p) + q;
        return this.sigma_0 * Math.pow(2.0, m / (double)this.Q);
    }

    public double getRelativeScale(double scaleA, double scaleB) {
        if (scaleA > scaleB) {
            throw new IllegalArgumentException("getRelativeScale(): scaleA > scaleB");
        }
        return Math.sqrt(scaleB * scaleB - scaleA * scaleA);
    }

    public double getRealX(int p, double xp) {
        return Math.pow(2.0, p) * xp;
    }

    public double getRealY(int p, double yp) {
        return Math.pow(2.0, p) * yp;
    }

    public void show() {
        this.show("");
    }

    public void show(String title) {
        if (!title.isEmpty()) {
            title = title + ": ";
        }
        for (int p = 0; p < this.P; ++p) {
            this.octaves[p].showAsStack(title + "Octave " + p);
        }
    }

    public void print() {
        IJ.log((String)("Hierarchical Scale Space (" + this.getClass().toString() + ")"));
        for (ScaleOctave oct : this.octaves) {
            oct.print();
        }
    }
}

