/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.datasets.sift;

import info.debatty.java.datasets.sift.ArrayIterator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LinearContainer<T>
implements Iterable<T> {
    private final int botIndex;
    private final int topIndex;
    private final T[] data;

    public LinearContainer(int n) {
        this(0, n - 1);
    }

    public LinearContainer(int botIndex, int topIndex) {
        if (botIndex > topIndex) {
            throw new IllegalArgumentException("LinearContainer: botIndex > topIndex");
        }
        this.botIndex = botIndex;
        this.topIndex = topIndex;
        int n = topIndex - botIndex + 1;
        this.data = new Object[n];
    }

    public T getElement(int k) {
        return this.data[k - this.botIndex];
    }

    public void setElement(int k, T elem) {
        this.data[k - this.botIndex] = elem;
    }

    public int getBotIndex() {
        return this.botIndex;
    }

    public int getTopIndex() {
        return this.topIndex;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator<T>(this.data);
    }
}

