/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.datasets.sift;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;

abstract class Matrix {
    public static final double EPSILON_DOUBLE = 2.0E-16;

    Matrix() {
    }

    public static double[] createDoubleVector(int length) {
        return new double[length];
    }

    public static float[] createFloatVector(int length) {
        return new float[length];
    }

    public static double[][] createDoubleMatrix(int rows, int columns) {
        return new double[rows][columns];
    }

    public static float[][] createFloatMatrix(int rows, int columns) {
        return new float[rows][columns];
    }

    public static int getNumberOfRows(double[][] A) {
        return A.length;
    }

    public static int getNumberOfColumns(double[][] A) {
        return A[0].length;
    }

    public static int getNumberOfRows(float[][] A) {
        return A.length;
    }

    public static int getNumberOfColumns(float[][] A) {
        return A[0].length;
    }

    public static double[] duplicate(double[] A) {
        return (double[])A.clone();
    }

    public static float[] duplicate(float[] A) {
        return (float[])A.clone();
    }

    public static double[][] duplicate(double[][] A) {
        int m = A.length;
        double[][] B = new double[m][];
        for (int i = 0; i < m; ++i) {
            B[i] = (double[])A[i].clone();
        }
        return B;
    }

    public static float[][] duplicateToFloat(double[][] A) {
        int m = A.length;
        int n = A[0].length;
        float[][] B = new float[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                B[i][j] = (float)A[i][j];
            }
        }
        return B;
    }

    public static float[][] duplicate(float[][] A) {
        int m = A.length;
        float[][] B = new float[m][];
        for (int i = 0; i < m; ++i) {
            B[i] = (float[])A[i].clone();
        }
        return B;
    }

    public static double[][] duplicateToDouble(float[][] A) {
        int m = A.length;
        int n = A[0].length;
        double[][] B = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                B[i][j] = A[i][j];
            }
        }
        return B;
    }

    public static int[] add(int[] a, int[] b) {
        int[] c = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = c[i] + b[i];
        }
        return c;
    }

    public static double[] add(double[] a, double[] b) {
        double[] c = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] + b[i];
        }
        return c;
    }

    public static double[][] add(double[][] A, double[][] B) {
        int m = A.length;
        int n = A[0].length;
        double[][] C = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                C[i][j] = A[i][j] + B[i][j];
            }
        }
        return C;
    }

    public static double[] subtract(double[] a, double[] b) {
        double[] c = (double[])a.clone();
        for (int i = 0; i < a.length; ++i) {
            c[i] = c[i] - b[i];
        }
        return c;
    }

    public static double[] subtract(double[] a, int[] b) {
        double[] c = (double[])a.clone();
        for (int i = 0; i < a.length; ++i) {
            c[i] = c[i] - (double)b[i];
        }
        return c;
    }

    public static int[] floor(double[] a) {
        int[] b = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            b[i] = (int)Math.floor(a[i]);
        }
        return b;
    }

    public static double[] multiply(double s, double[] a) {
        double[] b = (double[])a.clone();
        Matrix.multiplyD(s, b);
        return b;
    }

    public static void multiplyD(double s, double[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i] * s;
        }
    }

    public static double[][] multiply(double s, double[][] A) {
        double[][] B = Matrix.duplicate(A);
        Matrix.multiplyD(s, B);
        return B;
    }

    public static void multiplyD(double s, double[][] A) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = A[i][j] * s;
            }
        }
    }

    public static float[] multiply(float s, float[] A) {
        float[] B = Matrix.duplicate(A);
        Matrix.multiplyD(s, B);
        return B;
    }

    public static void multiplyD(float s, float[] A) {
        for (int i = 0; i < A.length; ++i) {
            A[i] = A[i] * s;
        }
    }

    public static float[][] multiply(float s, float[][] A) {
        float[][] B = Matrix.duplicate(A);
        for (int i = 0; i < B.length; ++i) {
            for (int j = 0; j < B[i].length; ++j) {
                B[i][j] = B[i][j] * s;
            }
        }
        return B;
    }

    public static void multiplyD(float s, float[][] A) {
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = A[i][j] * s;
            }
        }
    }

    public static double[] multiply(double[] x, double[][] A) {
        double[] Y = new double[Matrix.getNumberOfColumns(A)];
        Matrix.multiplyD(x, A, Y);
        return Y;
    }

    public static void multiplyD(double[] x, double[][] A, double[] y) {
        int m = Matrix.getNumberOfRows(A);
        int n = Matrix.getNumberOfColumns(A);
        if (x.length != m || y.length != n) {
            throw new IllegalArgumentException("incompatible vector-matrix dimensions");
        }
        for (int i = 0; i < n; ++i) {
            double s = 0.0;
            for (int j = 0; j < m; ++j) {
                s += x[j] * A[j][i];
            }
            y[i] = s;
        }
    }

    public static double[] multiply(double[][] A, double[] x) {
        double[] y = new double[Matrix.getNumberOfRows(A)];
        Matrix.multiplyD(A, x, y);
        return y;
    }

    public static void multiplyD(double[][] A, double[] x, double[] y) {
        int m = Matrix.getNumberOfRows(A);
        int n = Matrix.getNumberOfColumns(A);
        if (x.length != n || y.length != m) {
            throw new IllegalArgumentException("incompatible matrix-vector dimensions");
        }
        for (int i = 0; i < m; ++i) {
            double s = 0.0;
            for (int j = 0; j < n; ++j) {
                s += A[i][j] * x[j];
            }
            y[i] = s;
        }
    }

    public static float[] multiply(float[][] A, float[] x) {
        float[] y = new float[Matrix.getNumberOfRows(A)];
        Matrix.multiplyD(A, x, y);
        return y;
    }

    public static void multiplyD(float[][] A, float[] x, float[] y) {
        int m = Matrix.getNumberOfRows(A);
        int n = Matrix.getNumberOfColumns(A);
        if (x.length != n || y.length != m) {
            throw new IllegalArgumentException("incompatible matrix-vector dimensions");
        }
        for (int i = 0; i < m; ++i) {
            double s = 0.0;
            for (int j = 0; j < n; ++j) {
                s += (double)(A[i][j] * x[j]);
            }
            y[i] = (float)s;
        }
    }

    public static double[][] multiply(double[][] A, double[][] B) {
        int m = Matrix.getNumberOfRows(A);
        int q = Matrix.getNumberOfColumns(B);
        double[][] C = Matrix.createDoubleMatrix(m, q);
        Matrix.multiplyD(A, B, C);
        return C;
    }

    public static void multiplyD(double[][] A, double[][] B, double[][] C) {
        int mA = Matrix.getNumberOfRows(A);
        int nA = Matrix.getNumberOfColumns(A);
        int nB = Matrix.getNumberOfColumns(B);
        for (int i = 0; i < mA; ++i) {
            for (int j = 0; j < nB; ++j) {
                double s = 0.0;
                for (int k = 0; k < nA; ++k) {
                    s += A[i][k] * B[k][j];
                }
                C[i][j] = s;
            }
        }
    }

    public static float[][] multiply(float[][] A, float[][] B) {
        int mA = Matrix.getNumberOfRows(A);
        int nB = Matrix.getNumberOfColumns(B);
        float[][] C = Matrix.createFloatMatrix(mA, nB);
        Matrix.multiply(A, B, C);
        return C;
    }

    public static void multiply(float[][] A, float[][] B, float[][] C) {
        int mA = Matrix.getNumberOfRows(A);
        int nA = Matrix.getNumberOfColumns(A);
        int mB = Matrix.getNumberOfRows(B);
        int nB = Matrix.getNumberOfColumns(B);
        if (nA != mB) {
            throw new IllegalArgumentException("Matrix.multiply: wrong row/col dimensions");
        }
        for (int i = 0; i < mA; ++i) {
            for (int j = 0; j < nB; ++j) {
                float s = 0.0f;
                for (int k = 0; k < nA; ++k) {
                    s += A[i][k] * B[k][j];
                }
                C[i][j] = s;
            }
        }
    }

    public static double dotProduct(double[] A, double[] B) {
        double sum = 0.0;
        for (int i = 0; i < A.length; ++i) {
            sum += A[i] * B[i];
        }
        return sum;
    }

    public static double[][] outerProduct(double[] A, double[] B) {
        int m = A.length;
        int n = B.length;
        double[][] M = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                M[i][j] = A[i] * B[j];
            }
        }
        return M;
    }

    public static double normL1(double[] A) {
        double sum = 0.0;
        for (double x : A) {
            sum += Math.abs(x);
        }
        return sum;
    }

    public static double normL2(double[] A) {
        return Math.sqrt(Matrix.normL2squared(A));
    }

    public static double normL2squared(double[] A) {
        double sum = 0.0;
        for (double x : A) {
            sum += x * x;
        }
        return sum;
    }

    public static float normL1(float[] A) {
        double sum = 0.0;
        float[] arr$ = A;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double x = arr$[i$];
            sum += Math.abs(x);
        }
        return (float)sum;
    }

    public static float normL2(float[] A) {
        return (float)Math.sqrt(Matrix.normL2squared(A));
    }

    public static float normL2squared(float[] A) {
        double sum = 0.0;
        float[] arr$ = A;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double x = arr$[i$];
            sum += x * x;
        }
        return (float)sum;
    }

    public static double sum(double[] A) {
        double sum = 0.0;
        for (int i = 0; i < A.length; ++i) {
            sum += A[i];
        }
        return sum;
    }

    public static double sum(double[][] A) {
        double sum = 0.0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                sum += A[i][j];
            }
        }
        return sum;
    }

    public static float sum(float[] A) {
        double sum = 0.0;
        for (int i = 0; i < A.length; ++i) {
            sum += (double)A[i];
        }
        return (float)sum;
    }

    public static double sum(float[][] A) {
        double sum = 0.0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                sum += (double)A[i][j];
            }
        }
        return sum;
    }

    public static float min(float[] A) {
        float minval = Float.POSITIVE_INFINITY;
        for (float val : A) {
            if (!(val < minval)) continue;
            minval = val;
        }
        return minval;
    }

    public static double min(double[] A) {
        double minval = Double.POSITIVE_INFINITY;
        for (double val : A) {
            if (!(val < minval)) continue;
            minval = val;
        }
        return minval;
    }

    public static float max(float[] A) {
        float maxval = Float.NEGATIVE_INFINITY;
        for (float val : A) {
            if (!(val > maxval)) continue;
            maxval = val;
        }
        return maxval;
    }

    public static double max(double[] A) {
        double maxval = Double.NEGATIVE_INFINITY;
        for (double val : A) {
            if (!(val > maxval)) continue;
            maxval = val;
        }
        return maxval;
    }

    public static float[] concatenate(float[] ... as) {
        ArrayList<Float> vlist = new ArrayList<Float>();
        float[][] arr$ = as;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            float[] a;
            for (float val : a = arr$[i$]) {
                vlist.add(Float.valueOf(val));
            }
        }
        float[] va = new float[vlist.size()];
        int i = 0;
        Iterator i$ = vlist.iterator();
        while (i$.hasNext()) {
            float val;
            va[i] = val = ((Float)i$.next()).floatValue();
            ++i;
        }
        return va;
    }

    public static double[] concatenate(double[] ... as) {
        ArrayList<Double> vlist = new ArrayList<Double>();
        double[][] arr$ = as;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double[] a;
            for (double val : a = arr$[i$]) {
                vlist.add(val);
            }
        }
        double[] va = new double[vlist.size()];
        int i = 0;
        Iterator i$ = vlist.iterator();
        while (i$.hasNext()) {
            double val;
            va[i] = val = ((Double)i$.next()).doubleValue();
            ++i;
        }
        return va;
    }

    public static float determinant2x2(float[][] A) {
        return A[0][0] * A[1][1] - A[0][1] * A[1][0];
    }

    public static double determinant2x2(double[][] A) {
        return A[0][0] * A[1][1] - A[0][1] * A[1][0];
    }

    public static float determinant3x3(float[][] A) {
        return A[0][0] * A[1][1] * A[2][2] + A[0][1] * A[1][2] * A[2][0] + A[0][2] * A[1][0] * A[2][1] - A[2][0] * A[1][1] * A[0][2] - A[2][1] * A[1][2] * A[0][0] - A[2][2] * A[1][0] * A[0][1];
    }

    public static double determinant3x3(double[][] A) {
        return A[0][0] * A[1][1] * A[2][2] + A[0][1] * A[1][2] * A[2][0] + A[0][2] * A[1][0] * A[2][1] - A[2][0] * A[1][1] * A[0][2] - A[2][1] * A[1][2] * A[0][0] - A[2][2] * A[1][0] * A[0][1];
    }

    public static float[][] transpose(float[][] A) {
        int m = Matrix.getNumberOfRows(A);
        int n = Matrix.getNumberOfColumns(A);
        float[][] At = new float[n][m];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                At[j][i] = A[i][j];
            }
        }
        return At;
    }

    public static double[][] transpose(double[][] A) {
        int m = Matrix.getNumberOfRows(A);
        int n = Matrix.getNumberOfColumns(A);
        double[][] At = new double[n][m];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                At[j][i] = A[i][j];
            }
        }
        return At;
    }

    public static double froebeniusNorm(double[][] A) {
        int m = Matrix.getNumberOfRows(A);
        int n = Matrix.getNumberOfColumns(A);
        double s = 0.0;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                s += A[i][j] * A[i][j];
            }
        }
        return Math.sqrt(s);
    }

    public static double trace(double[][] A) {
        int n;
        int m = Matrix.getNumberOfRows(A);
        if (m != (n = Matrix.getNumberOfColumns(A))) {
            throw new IllegalArgumentException("square matrix expected");
        }
        double s = 0.0;
        for (int i = 0; i < m; ++i) {
            s += A[i][i];
        }
        return s;
    }

    public static double[][] inverse(double[][] A) {
        RealMatrix M = MatrixUtils.createRealMatrix((double[][])A);
        if (!M.isSquare()) {
            return null;
        }
        double[][] Ai = null;
        try {
            RealMatrix Mi = MatrixUtils.inverse((RealMatrix)M);
            Ai = Mi.getData();
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
        return Ai;
    }

    public static float[][] inverse(float[][] A) {
        double[][] B = Matrix.duplicateToDouble(A);
        double[][] Bi = Matrix.inverse(B);
        if (Bi == null) {
            return null;
        }
        return Matrix.duplicateToFloat(Bi);
    }

    public static double[] solve(double[][] A, double[] b) {
        RealMatrix AA = MatrixUtils.createRealMatrix((double[][])A);
        RealVector bb = MatrixUtils.createRealVector((double[])b);
        DecompositionSolver solver = new LUDecomposition(AA).getSolver();
        double[] x = null;
        try {
            x = solver.solve(bb).toArray();
        }
        catch (SingularMatrixException e) {
            // empty catch block
        }
        return x;
    }

    static {
        Locale.setDefault(Locale.US);
    }
}

