/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.datasets.sift;

import ij.process.FloatProcessor;
import info.debatty.java.datasets.sift.GaussianFilter;

class ScaleLevel
extends FloatProcessor {
    private double absoluteScale;

    public ScaleLevel(int width, int height, float[] data, double absoluteScale) {
        super(width, height, data, null);
        this.absoluteScale = absoluteScale;
    }

    public ScaleLevel(FloatProcessor fp, double absoluteScale) {
        this(fp.getWidth(), fp.getHeight(), (float[])((float[])fp.getPixels()).clone(), absoluteScale);
    }

    public ScaleLevel(ScaleLevel level) {
        this(level.getWidth(), level.getHeight(), (float[])((float[])level.getPixels()).clone(), level.absoluteScale);
    }

    public void filterGaussian(double sigma) {
        GaussianFilter gf = new GaussianFilter(sigma);
        gf.applyTo(this);
    }

    public ScaleLevel duplicate() {
        return new ScaleLevel(this);
    }

    public ScaleLevel decimate() {
        int width1 = this.getWidth();
        int height1 = this.getHeight();
        int width2 = width1 / 2;
        int height2 = height1 / 2;
        float[] pixels1 = (float[])this.getPixels();
        float[] pixels2 = new float[width2 * height2];
        for (int v2 = 0; v2 < height2; ++v2) {
            int v1 = 2 * v2;
            for (int u2 = 0; u2 < width2; ++u2) {
                int u1 = 2 * u2;
                pixels2[v2 * width2 + u2] = pixels1[v1 * width1 + u1];
            }
        }
        return new ScaleLevel(width2, height2, pixels2, this.absoluteScale);
    }

    public ScaleLevel subtract(FloatProcessor B) {
        ScaleLevel A = this.duplicate();
        float[] pixelsA = (float[])A.getPixels();
        float[] pixelsB = (float[])B.getPixels();
        for (int i = 0; i < pixelsA.length; ++i) {
            pixelsA[i] = pixelsA[i] - pixelsB[i];
        }
        A.setAbsoluteScale(0.0);
        return A;
    }

    public void setAbsoluteScale(double sigma) {
        this.absoluteScale = sigma;
    }

    public double getAbsoluteScale() {
        return this.absoluteScale;
    }

    public void get3x3Neighborhood(int u, int v, float[][] nh) {
        int i = 0;
        int x = u - 1;
        while (i < 3) {
            int j = 0;
            int y = v - 1;
            while (j < 3) {
                nh[i][j] = this.getf(x, y);
                ++j;
                ++y;
            }
            ++i;
            ++x;
        }
    }

    public void getGradientPolar(int u, int v, double[] grad) {
        double grad_x = this.getf(u + 1, v) - this.getf(u - 1, v);
        double grad_y = this.getf(u, v + 1) - this.getf(u, v - 1);
        grad[0] = Math.sqrt(grad_x * grad_x + grad_y * grad_y);
        grad[1] = Math.atan2(grad_y, grad_x);
    }
}

