/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.datasets.sift;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import info.debatty.java.datasets.sift.LinearContainer;
import info.debatty.java.datasets.sift.ScaleLevel;
import java.util.Locale;

abstract class ScaleOctave {
    double sigma_0 = 1.6;
    int Q = 3;
    final int p;
    final int width;
    final int height;
    final int botLevelIndex;
    final int topLevelIndex;
    final LinearContainer<ScaleLevel> levels;

    ScaleOctave(int p, int Q, int width, int height, int botLevelIndex, int topLevelIndex) {
        this.p = p;
        this.Q = Q;
        this.width = width;
        this.height = height;
        if (botLevelIndex > topLevelIndex) {
            throw new IllegalArgumentException("ScaleOctave (constructor): botLevelIndex > topLevelIndex");
        }
        this.botLevelIndex = botLevelIndex;
        this.topLevelIndex = topLevelIndex;
        this.levels = new LinearContainer(botLevelIndex, topLevelIndex);
    }

    ScaleOctave(int p, int Q, ScaleLevel level_b, int botIndex, int topIndex) {
        this(p, Q, level_b.getWidth(), level_b.getHeight(), botIndex, topIndex);
        this.setLevel(botIndex, level_b);
    }

    public int getOctaveIndex() {
        return this.p;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ScaleLevel getLevel(int q) {
        return this.levels.getElement(q);
    }

    void setLevel(int q, ScaleLevel level) {
        this.levels.setElement(q, level);
    }

    public boolean isInside(int q, int u, int v) {
        return this.botLevelIndex < q && q < this.topLevelIndex && 0 < u && u < this.width - 1 && 0 < v && v < this.height - 1;
    }

    public double getAbsoluteScale(int q) {
        return this.getLevel(q).getAbsoluteScale();
    }

    int getBottomLevelIndex() {
        return this.botLevelIndex;
    }

    int getTopLevelIndex() {
        return this.topLevelIndex;
    }

    public void getNeighborhood(int q, int u, int v, float[][][] nh) {
        int s = 0;
        int level = q - 1;
        while (s < 3) {
            this.getLevel(level).get3x3Neighborhood(u, v, nh[s]);
            ++s;
            ++level;
        }
    }

    public void print() {
        IJ.log((String)("  Scale Octave p=" + this.p));
        for (int q = this.botLevelIndex; q <= this.topLevelIndex; ++q) {
            ScaleLevel level = this.getLevel(q);
            if (level == null) continue;
            double scale = level.getAbsoluteScale();
            IJ.log((String)String.format(Locale.US, "   level (p=%d, q=%d, \u03c3=%.4f)", this.p, q, scale));
        }
    }

    public void show(String name, int p) {
        for (int q = this.botLevelIndex; q <= this.topLevelIndex; ++q) {
            ScaleLevel level = this.getLevel(q);
            if (level == null) continue;
            double scale = level.getAbsoluteScale();
            String title = String.format(Locale.US, "%s (p=%d, q=%d, \u03c3=%.4f)", name, p, q, scale);
            level.resetMinAndMax();
            new ImagePlus(title, (ImageProcessor)level).show();
        }
    }

    public void showAsStack(String name) {
        ImageStack stk = new ImageStack(this.width, this.height);
        for (int q = this.botLevelIndex; q <= this.topLevelIndex; ++q) {
            ScaleLevel level = this.getLevel(q);
            if (level == null) continue;
            double scale = level.getAbsoluteScale();
            String title = String.format(Locale.US, "q=%d, \u03c3=%.4f", q, scale);
            stk.addSlice(title, (ImageProcessor)level);
        }
        new ImagePlus(name, stk).show();
    }

    public void showAsStack(String name, int p) {
        ImageStack stk = new ImageStack(this.width, this.height);
        for (int q = this.botLevelIndex; q <= this.topLevelIndex; ++q) {
            ScaleLevel level = this.getLevel(q);
            if (level == null) continue;
            double scale = level.getAbsoluteScale();
            String title = String.format(Locale.US, "p=%d, q=%d, \u03c3=%.4f", p, q, scale);
            stk.addSlice(title, (ImageProcessor)level);
        }
        new ImagePlus(name, stk).show();
    }

    public int getScaleIndex(int p, int q) {
        int m = this.Q * p + q;
        return m;
    }

    public double getAbsoluteScale(int p, int q) {
        double m = this.getScaleIndex(p, q);
        double sigma = this.sigma_0 * Math.pow(2.0, m / (double)this.Q);
        return sigma;
    }
}

