/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.datasets.sift;

import ij.IJ;
import ij.process.FloatProcessor;
import info.debatty.java.datasets.sift.DogScaleSpace;
import info.debatty.java.datasets.sift.GaussianScaleSpace;
import info.debatty.java.datasets.sift.KeyPoint;
import info.debatty.java.datasets.sift.Matrix;
import info.debatty.java.datasets.sift.ScaleLevel;
import info.debatty.java.datasets.sift.ScaleOctave;
import info.debatty.java.datasets.sift.SiftFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SiftDetector {
    private final Parameters params;
    static final float EPSILON_F = 1.0E-35f;
    static final double PI2 = Math.PI * 2;
    private GaussianScaleSpace G;
    private DogScaleSpace D;
    private int nhSize;

    public SiftDetector(FloatProcessor fp) {
        this(fp, new Parameters());
    }

    public SiftDetector(FloatProcessor fp, Parameters params) {
        this.normalize(fp);
        this.params = params;
        this.nhSize = params.nhType.size;
        this.G = new GaussianScaleSpace(fp, params.sigma_s, params.sigma_0, params.P, params.Q, -1, params.Q + 1);
        this.D = new DogScaleSpace(this.G);
    }

    public List<KeyPoint> makeRichKeypoints(List<KeyPoint> keypoints) {
        if (this.params.DEBUG) {
            IJ.log((String)"makeSiftDescriptors...");
        }
        ArrayList<KeyPoint> richKeyPoints = new ArrayList<KeyPoint>();
        for (KeyPoint kp : keypoints) {
            float[] oh = this.getOrientationHistogram(kp);
            this.smoothCircular(oh, this.params.n_Smooth);
            kp.orientation_histogram = oh;
            List<Double> peakOrientations = this.findPeakOrientationIndices(oh);
            if (this.params.DEBUG && peakOrientations.size() == 0) {
                IJ.log((String)("insufficient orientations at " + kp.u + "/" + kp.v));
            }
            for (double km : peakOrientations) {
                float phi = (float)(km * 2.0 * Math.PI / (double)oh.length);
                KeyPoint rkp = kp.clone();
                rkp.orientation = phi;
                richKeyPoints.add(rkp);
            }
        }
        if (this.params.DEBUG) {
            IJ.log((String)"makeSiftDescriptors...done");
        }
        return richKeyPoints;
    }

    public List<Double> findPeakOrientationIndices(float[] oh) {
        int nb = oh.length;
        ArrayList<Double> orientIndexes = new ArrayList<Double>(nb);
        float maxh = oh[0];
        for (int k = 1; k < nb; ++k) {
            if (!(oh[k] > maxh)) continue;
            maxh = oh[k];
        }
        if (maxh > 0.01f) {
            float minh = maxh * (float)this.params.t_DomOr;
            for (int k = 0; k < nb; ++k) {
                float hc = oh[k];
                if (!(oh[k] > minh)) continue;
                float hp = oh[(k - 1 + nb) % nb];
                float hn = oh[(k + 1) % nb];
                if (!(hc > hp) || !(hc > hn)) continue;
                double delta = this.interpolateQuadratic(hp, hc, hn);
                double k_max = ((double)k + delta + (double)nb) % (double)nb;
                orientIndexes.add(k_max);
            }
        }
        return orientIndexes;
    }

    public List<SiftFeature> getSiftFeatures() {
        List<KeyPoint> keyPoints = this.getKeyPoints();
        ArrayList<SiftFeature> siftDescriptors = new ArrayList<SiftFeature>();
        for (KeyPoint c : keyPoints) {
            for (double phi_d : this.getDominantOrientations(c)) {
                SiftFeature sd = this.makeSiftDescriptor(c, phi_d);
                if (sd == null) continue;
                siftDescriptors.add(sd);
            }
        }
        return siftDescriptors;
    }

    public List<KeyPoint> getKeyPoints() {
        ArrayList<KeyPoint> keyPts = new ArrayList<KeyPoint>();
        int P = this.params.P;
        int K = this.params.Q;
        for (int p = 0; p <= P - 1; ++p) {
            for (int q = 0; q <= K - 1; ++q) {
                List<KeyPoint> extrema = this.findExtrema(p, q);
                for (KeyPoint e : extrema) {
                    KeyPoint c = this.refineKeyPosition(this.D, e);
                    if (c == null) continue;
                    keyPts.add(c);
                }
            }
        }
        if (this.params.sortKeyPoints) {
            Collections.sort(keyPts);
        }
        return keyPts;
    }

    private List<KeyPoint> findExtrema(int p, int q) {
        float tMag = (float)this.params.t_Mag;
        float tExtrm = (float)this.params.t_Extrm;
        ScaleOctave Dp = this.D.getOctave(p);
        ScaleLevel Dpq = this.D.getScaleLevel(p, q);
        int M = Dpq.getWidth();
        int N = Dpq.getHeight();
        ArrayList<KeyPoint> E = new ArrayList<KeyPoint>();
        float scale = (float)this.D.getAbsoluteScale(p, q);
        float[][][] nh = new float[3][3][3];
        for (int u = 1; u <= M - 2; ++u) {
            float x_real = (float)this.D.getRealX(p, u);
            for (int v = 1; v <= N - 2; ++v) {
                float y_real = (float)this.D.getRealY(p, v);
                float mag = Math.abs(Dpq.getf(u, v));
                if (!(mag > tMag)) continue;
                Dp.getNeighborhood(q, u, v, nh);
                if (!this.isExtremum(nh, tExtrm)) continue;
                KeyPoint e = new KeyPoint(p, q, u, v, u, v, x_real, y_real, scale, mag);
                E.add(e);
            }
        }
        return E;
    }

    private KeyPoint refineKeyPosition(DogScaleSpace D, KeyPoint k) {
        int p = k.p;
        int q = k.q;
        int u = k.u;
        int v = k.v;
        ScaleOctave Dp = D.getOctave(p);
        double rhoMax = this.params.rho_Max;
        float[][][] nh = new float[3][3][3];
        float[] grad = new float[3];
        float[] d = new float[3];
        float[][] hess = new float[3][3];
        double tPeak = this.params.t_Peak;
        int n_max = this.params.n_Refine;
        float aMax = (float)(this.sqr(rhoMax + 1.0) / rhoMax);
        KeyPoint kr = null;
        boolean done = false;
        for (int n = 1; !done && n <= n_max && Dp.isInside(q, u, v); ++n) {
            Dp.getNeighborhood(q, u, v, nh);
            this.gradient(nh, grad);
            this.hessian(nh, hess);
            double detH = Matrix.determinant3x3(hess);
            if (Math.abs(detH) < (double)1.0E-35f) {
                done = true;
                continue;
            }
            float dxx = hess[0][0];
            float dxy = hess[0][1];
            float dyy = hess[1][1];
            float[][] invHess = Matrix.inverse(hess);
            Matrix.multiplyD(invHess, grad, d);
            Matrix.multiplyD(-1.0f, d);
            float xx = d[0];
            float yy = d[1];
            if (Math.abs(xx) < 0.5f && Math.abs(yy) < 0.5f) {
                float a;
                done = true;
                float Dpeak = nh[1][1][1] + 0.5f * (grad[0] * xx + grad[1] * yy + grad[2] * d[2]);
                float detHxy = dxx * dyy - dxy * dxy;
                if (!((double)Math.abs(Dpeak) > tPeak) || !(detHxy > 0.0f) || !((a = this.sqr(dxx + dyy) / detHxy) <= aMax)) continue;
                if (this.params.DEBUG) {
                    IJ.log((String)(k.toString() + String.format(": added after %d tries, alpha = %f", n, Float.valueOf(a))));
                }
                kr = k;
                kr.x = (float)u + xx;
                kr.y = (float)v + yy;
                kr.x_real = (float)D.getRealX(p, kr.x);
                kr.y_real = (float)D.getRealY(p, kr.y);
                kr.scale = (float)D.getAbsoluteScale(p, q);
                continue;
            }
            u += Math.min(1, Math.max(-1, Math.round(xx)));
            v += Math.min(1, Math.max(-1, Math.round(yy)));
        }
        return kr;
    }

    private boolean isExtremum(float[][][] nh, float tExtrm) {
        return this.isLocalMin(nh, tExtrm) || this.isLocalMax(nh, tExtrm);
    }

    boolean isLocalMin(float[][][] neighborhood, float tExtrm) {
        float c = neighborhood[1][1][1] + tExtrm;
        if (c >= 0.0f) {
            return false;
        }
        if (c >= neighborhood[1][0][0]) {
            return false;
        }
        if (c >= neighborhood[1][1][0]) {
            return false;
        }
        if (c >= neighborhood[1][2][0]) {
            return false;
        }
        if (c >= neighborhood[1][0][1]) {
            return false;
        }
        if (c >= neighborhood[1][2][1]) {
            return false;
        }
        if (c >= neighborhood[1][0][2]) {
            return false;
        }
        if (c >= neighborhood[1][1][2]) {
            return false;
        }
        if (c >= neighborhood[1][2][2]) {
            return false;
        }
        if (this.nhSize >= 10) {
            if (c >= neighborhood[0][1][1]) {
                return false;
            }
            if (c >= neighborhood[2][1][1]) {
                return false;
            }
            if (this.nhSize >= 18) {
                if (c >= neighborhood[0][0][1]) {
                    return false;
                }
                if (c >= neighborhood[0][2][1]) {
                    return false;
                }
                if (c >= neighborhood[0][1][0]) {
                    return false;
                }
                if (c >= neighborhood[0][1][2]) {
                    return false;
                }
                if (c >= neighborhood[2][0][1]) {
                    return false;
                }
                if (c >= neighborhood[2][2][1]) {
                    return false;
                }
                if (c >= neighborhood[2][1][0]) {
                    return false;
                }
                if (c >= neighborhood[2][1][2]) {
                    return false;
                }
                if (this.nhSize >= 26) {
                    if (c >= neighborhood[0][0][0]) {
                        return false;
                    }
                    if (c >= neighborhood[0][2][0]) {
                        return false;
                    }
                    if (c >= neighborhood[0][0][2]) {
                        return false;
                    }
                    if (c >= neighborhood[0][2][2]) {
                        return false;
                    }
                    if (c >= neighborhood[2][0][0]) {
                        return false;
                    }
                    if (c >= neighborhood[2][2][0]) {
                        return false;
                    }
                    if (c >= neighborhood[2][0][2]) {
                        return false;
                    }
                    if (c >= neighborhood[2][2][2]) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    boolean isLocalMax(float[][][] neighborhood, float tExtrm) {
        float c = neighborhood[1][1][1] - tExtrm;
        if (c <= 0.0f) {
            return false;
        }
        if (c <= neighborhood[1][0][0]) {
            return false;
        }
        if (c <= neighborhood[1][1][0]) {
            return false;
        }
        if (c <= neighborhood[1][2][0]) {
            return false;
        }
        if (c <= neighborhood[1][0][1]) {
            return false;
        }
        if (c <= neighborhood[1][2][1]) {
            return false;
        }
        if (c <= neighborhood[1][0][2]) {
            return false;
        }
        if (c <= neighborhood[1][1][2]) {
            return false;
        }
        if (c <= neighborhood[1][2][2]) {
            return false;
        }
        if (this.nhSize >= 10) {
            if (c <= neighborhood[0][1][1]) {
                return false;
            }
            if (c <= neighborhood[2][1][1]) {
                return false;
            }
            if (this.nhSize >= 18) {
                if (c <= neighborhood[0][0][1]) {
                    return false;
                }
                if (c <= neighborhood[0][2][1]) {
                    return false;
                }
                if (c <= neighborhood[0][1][0]) {
                    return false;
                }
                if (c <= neighborhood[0][1][2]) {
                    return false;
                }
                if (c <= neighborhood[2][0][1]) {
                    return false;
                }
                if (c <= neighborhood[2][2][1]) {
                    return false;
                }
                if (c <= neighborhood[2][1][0]) {
                    return false;
                }
                if (c <= neighborhood[2][1][2]) {
                    return false;
                }
                if (this.nhSize >= 26) {
                    if (c <= neighborhood[0][0][0]) {
                        return false;
                    }
                    if (c <= neighborhood[0][2][0]) {
                        return false;
                    }
                    if (c <= neighborhood[0][0][2]) {
                        return false;
                    }
                    if (c <= neighborhood[0][2][2]) {
                        return false;
                    }
                    if (c <= neighborhood[2][0][0]) {
                        return false;
                    }
                    if (c <= neighborhood[2][2][0]) {
                        return false;
                    }
                    if (c <= neighborhood[2][0][2]) {
                        return false;
                    }
                    if (c <= neighborhood[2][2][2]) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    float[] gradient(float[][][] nh, float[] grad) {
        grad[0] = 0.5f * (nh[1][2][1] - nh[1][0][1]);
        grad[1] = 0.5f * (nh[1][1][2] - nh[1][1][0]);
        grad[2] = 0.5f * (nh[2][1][1] - nh[0][1][1]);
        return grad;
    }

    float[][] hessian(float[][][] nh, float[][] hess) {
        float nh_111 = 2.0f * nh[1][1][1];
        float dxx = nh[1][0][1] - nh_111 + nh[1][2][1];
        float dyy = nh[1][1][0] - nh_111 + nh[1][1][2];
        float dss = nh[0][1][1] - nh_111 + nh[2][1][1];
        float dxy = (nh[1][2][2] - nh[1][0][2] - nh[1][2][0] + nh[1][0][0]) * 0.25f;
        float dxs = (nh[2][2][1] - nh[2][0][1] - nh[0][2][1] + nh[0][0][1]) * 0.25f;
        float dys = (nh[2][1][2] - nh[2][1][0] - nh[0][1][2] + nh[0][1][0]) * 0.25f;
        hess[0][0] = dxx;
        hess[0][1] = dxy;
        hess[0][2] = dxs;
        hess[1][0] = dxy;
        hess[1][1] = dyy;
        hess[1][2] = dys;
        hess[2][0] = dxs;
        hess[2][1] = dys;
        hess[2][2] = dss;
        return hess;
    }

    void printMatrix3x3(float[][] A) {
        IJ.log((String)String.format(Locale.US, "{{%.6f, %.6f, %.6f},", Float.valueOf(A[0][0]), Float.valueOf(A[0][1]), Float.valueOf(A[0][2])));
        IJ.log((String)String.format(Locale.US, " {%.6f, %.6f, %.6f},", Float.valueOf(A[1][0]), Float.valueOf(A[1][1]), Float.valueOf(A[1][2])));
        IJ.log((String)String.format(Locale.US, " {%.6f, %.6f, %.6f}}", Float.valueOf(A[2][0]), Float.valueOf(A[2][1]), Float.valueOf(A[2][2])));
    }

    List<Double> getDominantOrientations(KeyPoint c) {
        float[] h_phi = this.getOrientationHistogram(c);
        this.smoothCircular(h_phi, this.params.n_Smooth);
        return this.findPeakOrientations(h_phi);
    }

    void smoothCircular(float[] X, int n_iter) {
        float[] H = new float[]{0.25f, 0.5f, 0.25f};
        int n = X.length;
        for (int i = 1; i <= n_iter; ++i) {
            float s = X[0];
            float p = X[n - 1];
            for (int j = 0; j <= n - 2; ++j) {
                float c = X[j];
                X[j] = H[0] * p + H[1] * X[j] + H[2] * X[j + 1];
                p = c;
            }
            X[n - 1] = H[0] * p + H[1] * X[n - 1] + H[2] * s;
        }
    }

    List<Double> findPeakOrientations(float[] h_phi) {
        int n = h_phi.length;
        ArrayList<Double> angles = new ArrayList<Double>(n);
        float h_max = h_phi[0];
        for (int k = 1; k < n; ++k) {
            if (!(h_phi[k] > h_max)) continue;
            h_max = h_phi[k];
        }
        if (h_max > 0.01f) {
            float h_min = h_max * 0.8f;
            for (int k = 0; k < n; ++k) {
                float hc = h_phi[k];
                if (!(hc > h_min)) continue;
                float hp = h_phi[(k - 1 + n) % n];
                float hn = h_phi[(k + 1) % n];
                if (!(hc > hp) || !(hc > hn)) continue;
                double delta = this.interpolateQuadratic(hp, hc, hn);
                double k_max = ((double)k + delta + (double)n) % (double)n;
                double phi_max = k_max * 2.0 * Math.PI / (double)n;
                angles.add(phi_max);
            }
        }
        return angles;
    }

    float[] getOrientationHistogram(KeyPoint c) {
        int n_phi = this.params.n_Orient;
        int K = this.params.Q;
        ScaleLevel Gpq = this.G.getScaleLevel(c.p, c.q);
        float[] h_phi = new float[n_phi];
        int M = Gpq.getWidth();
        int N = Gpq.getHeight();
        double x = c.x;
        double y = c.y;
        double sigma_w = 1.5 * this.params.sigma_0 * Math.pow(2.0, (double)c.q / (double)K);
        double sigma_w22 = 2.0 * sigma_w * sigma_w;
        double r_w = Math.max(1.0, 2.5 * sigma_w);
        double r_w2 = r_w * r_w;
        int u_min = Math.max((int)Math.floor(x - r_w), 1);
        int u_max = Math.min((int)Math.ceil(x + r_w), M - 2);
        int v_min = Math.max((int)Math.floor(y - r_w), 1);
        int v_max = Math.min((int)Math.ceil(y + r_w), N - 2);
        double[] gradPol = new double[2];
        for (int u = u_min; u <= u_max; ++u) {
            double dx = (double)u - x;
            for (int v = v_min; v <= v_max; ++v) {
                double dy = (double)v - y;
                double r2 = dx * dx + dy * dy;
                if (!(r2 < r_w2)) continue;
                Gpq.getGradientPolar(u, v, gradPol);
                double E = gradPol[0];
                double phi = gradPol[1];
                double wG = Math.exp(-(dx * dx + dy * dy) / sigma_w22);
                double z = E * wG;
                double k_phi = (double)n_phi * phi / (Math.PI * 2);
                double alpha = k_phi - Math.floor(k_phi);
                int k_0 = this.mod((int)Math.floor(k_phi), n_phi);
                int k_1 = this.mod(k_0 + 1, n_phi);
                h_phi[k_0] = (float)((double)h_phi[k_0] + (1.0 - alpha) * z);
                h_phi[k_1] = (float)((double)h_phi[k_1] + alpha * z);
            }
        }
        return h_phi;
    }

    SiftFeature makeSiftDescriptor(KeyPoint c, double phi_d) {
        int p = c.p;
        int q = c.q;
        double x = c.x;
        double y = c.y;
        double mag = c.magnitude;
        ScaleLevel Gpq = this.G.getScaleLevel(p, q);
        int M = Gpq.getWidth();
        int N = Gpq.getHeight();
        int K = this.G.getQ();
        double sigma_q = this.G.getSigma_0() * Math.pow(2.0, (double)q / (double)K);
        double w_d = this.params.s_Desc * sigma_q;
        double sigma_d = 0.25 * w_d;
        double sigma_d2 = 2.0 * sigma_d * sigma_d;
        double r_d = 2.5 * sigma_d;
        double r_d2 = r_d * r_d;
        double sc = 1.0 / w_d;
        double sin_phi_d = Math.sin(-phi_d);
        double cos_phi_d = Math.cos(-phi_d);
        int u_min = Math.max((int)Math.floor(x - r_d), 1);
        int u_max = Math.min((int)Math.ceil(x + r_d), M - 2);
        int v_min = Math.max((int)Math.floor(y - r_d), 1);
        int v_max = Math.min((int)Math.ceil(y + r_d), N - 2);
        int n_Spat = this.params.n_Spat;
        int n_Angl = this.params.n_Angl;
        double[][][] h_grad = new double[n_Spat][n_Spat][n_Angl];
        double[] gmo = new double[2];
        for (int u = u_min; u <= u_max; ++u) {
            double dx = (double)u - x;
            for (int v = v_min; v <= v_max; ++v) {
                double dy = (double)v - y;
                double r2 = this.sqr(dx) + this.sqr(dy);
                if (!(r2 < r_d2)) continue;
                double uu = sc * (cos_phi_d * dx - sin_phi_d * dy);
                double vv = sc * (sin_phi_d * dx + cos_phi_d * dy);
                Gpq.getGradientPolar(u, v, gmo);
                double E = gmo[0];
                double phi = gmo[1];
                double phi_norm = this.mod(phi - phi_d, Math.PI * 2);
                double w_G = Math.exp(-r2 / sigma_d2);
                double z = E * w_G;
                this.updateGradientHistogram(h_grad, uu, vv, phi_norm, z);
            }
        }
        int[] f_int = this.makeFeatureVector(h_grad);
        double sigma_pq = this.G.getAbsoluteScale(p, q);
        double x_real = this.G.getRealX(p, x);
        double y_real = this.G.getRealY(p, y);
        return new SiftFeature(x_real, y_real, sigma_pq, mag, phi_d, f_int);
    }

    private void updateGradientHistogram(double[][][] h_grad, double uu, double vv, double phi_norm, double z) {
        int n_Spat = this.params.n_Spat;
        int n_Angl = this.params.n_Angl;
        double ii = (double)n_Spat * uu + 0.5 * (double)(n_Spat - 1);
        double jj = (double)n_Spat * vv + 0.5 * (double)(n_Spat - 1);
        double kk = phi_norm * ((double)n_Angl / (Math.PI * 2));
        int i0 = (int)Math.floor(ii);
        int i1 = i0 + 1;
        int j0 = (int)Math.floor(jj);
        int j1 = j0 + 1;
        int k0 = this.mod((int)Math.floor(kk), n_Angl);
        int k1 = (k0 + 1) % n_Angl;
        double alpha0 = 1.0 - (ii - (double)i0);
        double alpha1 = 1.0 - alpha0;
        double beta0 = 1.0 - (jj - (double)j0);
        double beta1 = 1.0 - beta0;
        double gamma0 = 1.0 - (kk - Math.floor(kk));
        double gamma1 = 1.0 - gamma0;
        int[] I = new int[]{i0, i1};
        int[] J = new int[]{j0, j1};
        int[] K = new int[]{k0, k1};
        double[] A = new double[]{alpha0, alpha1};
        double[] B = new double[]{beta0, beta1};
        double[] C = new double[]{gamma0, gamma1};
        for (int a = 0; a <= 1; ++a) {
            int i = I[a];
            if (i < 0 || i >= n_Spat) continue;
            double wa = A[a];
            for (int b = 0; b <= 1; ++b) {
                int j = J[b];
                if (j < 0 || j >= n_Spat) continue;
                double wb = B[b];
                for (int c = 0; c <= 1; ++c) {
                    int k = K[c];
                    double wc = C[c];
                    h_grad[i][j][k] = h_grad[i][j][k] + z * wa * wb * wc;
                }
            }
        }
    }

    private int[] makeFeatureVector(double[][][] h_grad) {
        int n_Spat = this.params.n_Spat;
        int n_Angl = this.params.n_Angl;
        float[] f = new float[n_Spat * n_Spat * n_Angl];
        int m = 0;
        for (int i = 0; i < n_Spat; ++i) {
            for (int j = 0; j < n_Spat; ++j) {
                for (int k = 0; k < n_Angl; ++k) {
                    f[m] = (float)h_grad[i][j][k];
                    ++m;
                }
            }
        }
        this.normalize(f);
        this.clipPeaks(f, (float)this.params.t_Fclip);
        this.normalize(f);
        return this.mapToIntegers(f, (float)this.params.s_Fscale);
    }

    private void normalize(float[] x) {
        double norm = this.normL2(x);
        if (norm > (double)1.0E-35f) {
            float s = (float)(1.0 / norm);
            for (int i = 0; i < x.length; ++i) {
                x[i] = s * x[i];
            }
        }
    }

    private void clipPeaks(float[] x, float xmax) {
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] > xmax)) continue;
            x[i] = xmax;
        }
    }

    private int[] mapToIntegers(float[] x, float s) {
        int[] ivec = new int[x.length];
        for (int i = 0; i < x.length; ++i) {
            ivec[i] = Math.round(s * x[i]);
        }
        return ivec;
    }

    private void normalize(FloatProcessor fp) {
        double minVal = fp.getMin();
        double maxVal = fp.getMax();
        fp.add(-minVal);
        fp.multiply(1.0 / (maxVal - minVal));
    }

    private float sqr(float x) {
        return x * x;
    }

    private double sqr(double x) {
        return x * x;
    }

    private int mod(int a, int b) {
        if (b == 0) {
            return a;
        }
        if (a * b >= 0) {
            return a - b * (a / b);
        }
        return a - b * (a / b - 1);
    }

    private double mod(double a, double n) {
        return a - n * Math.floor(a / n);
    }

    private double normL2(float[] vec) {
        double sum = 0.0;
        for (float x : vec) {
            sum += (double)(x * x);
        }
        return Math.sqrt(sum);
    }

    private float interpolateQuadratic(float y1, float y2, float y3) {
        float a = (y1 - 2.0f * y2 + y3) / 2.0f;
        if (Math.abs(a) < 1.0E-5f) {
            throw new IllegalArgumentException("quadratic interpolation failed " + a + " " + y1 + " " + y2 + " " + y3);
        }
        float b = (y3 - y1) / 2.0f;
        float x_extrm = -b / (2.0f * a);
        return x_extrm;
    }

    void print(float[] arr) {
        int linelength = 16;
        StringBuilder sb = new StringBuilder();
        Formatter fm = new Formatter(sb, Locale.US);
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0 && i % linelength == 0) {
                IJ.log((String)sb.toString());
                sb.setLength(0);
            }
            fm.format(" %.2f", Float.valueOf(arr[i]));
        }
        IJ.log((String)sb.toString());
        fm.close();
    }

    String logvar(float x, String name) {
        return name + " = " + String.format("%.3f ", Float.valueOf(x));
    }

    String logvar(double x, String name) {
        return name + " = " + String.format("%.3f ", x);
    }

    String logvar(int x, String name) {
        return name + " = " + x + " ";
    }

    void Debug(String s) {
        IJ.log((String)s);
    }

    void Stop() {
        throw new IllegalArgumentException("HALTED");
    }

    public void printGaussianScaleSpace() {
        this.G.print();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NeighborhoodType {
        NH8(8),
        NH10(10),
        NH18(18),
        NH26(26);

        private final int size;

        private NeighborhoodType(int size) {
            this.size = size;
        }
    }

    public static class Parameters {
        public boolean DEBUG = false;
        public NeighborhoodType nhType = NeighborhoodType.NH18;
        public double sigma_s = 0.5;
        public double sigma_0 = 1.6;
        public int P = 4;
        public int Q = 3;
        public double t_Mag;
        public double t_Peak = this.t_Mag = 0.01;
        public double t_Extrm = 0.0;
        public int n_Refine = 5;
        public double rho_Max = 10.0;
        public int n_Orient = 36;
        public int n_Smooth = 2;
        public double t_DomOr = 0.8;
        public double s_Desc = 10.0;
        public int n_Spat = 4;
        public int n_Angl = 8;
        public double t_Fclip = 0.2;
        public double s_Fscale = 512.0;
        public boolean sortKeyPoints = true;
    }
}

