/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.datasets.sift;

import info.debatty.java.datasets.sift.SiftFeature;
import info.debatty.java.datasets.sift.SiftMatch;
import info.debatty.java.datasets.sift.VectorNorm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiftMatcher {
    private final Parameters params;
    private final SiftFeature[] fA;
    private final VectorNorm am;

    public SiftMatcher(List<SiftFeature> sfA) {
        this(sfA, new Parameters());
    }

    public SiftMatcher(List<SiftFeature> sfA, Parameters params) {
        this.fA = sfA.toArray(new SiftFeature[0]);
        this.params = params;
        this.am = params.norm.create();
    }

    public List<SiftMatch> matchDescriptors(List<SiftFeature> sfB) {
        SiftFeature[] fB = sfB.toArray(new SiftFeature[0]);
        ArrayList<SiftMatch> matches = new ArrayList<SiftMatch>(this.fA.length);
        for (int i = 0; i < this.fA.length; ++i) {
            SiftFeature si = this.fA[i];
            int i1 = -1;
            int i2 = -1;
            double d1 = Double.MAX_VALUE;
            double d2 = Double.MAX_VALUE;
            for (int j = 0; j < fB.length; ++j) {
                double d = this.dist(si, fB[j]);
                if (d < d1) {
                    i2 = i1;
                    d2 = d1;
                    i1 = j;
                    d1 = d;
                    continue;
                }
                if (!(d < d2)) continue;
                i2 = j;
                d2 = d;
            }
            if (i2 < 0 || !(d2 > 0.001) || !(d1 / d2 < this.params.rho_max)) continue;
            SiftFeature s1 = fB[i1];
            SiftMatch m = new SiftMatch(si, s1, d1);
            matches.add(m);
        }
        if (this.params.sort) {
            Collections.sort(matches);
        }
        return matches;
    }

    double dist(SiftFeature d1, SiftFeature d2) {
        return this.am.distance(d1.getFeatures(), d2.getFeatures());
    }

    public static class Parameters {
        public VectorNorm.NormType norm = VectorNorm.NormType.L2;
        public double rho_max = 0.8;
        public boolean sort = true;
    }
}

