/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs;

import info.debatty.java.graphs.CallbackInterface;
import info.debatty.java.graphs.GraphBuilder;
import info.debatty.java.graphs.Neighbor;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.Node;
import info.debatty.java.graphs.SimilarityInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Brute
extends GraphBuilder {
    public static void main(String[] args) {
        Random r = new Random();
        int count = 1000;
        ArrayList<Node> nodes = new ArrayList<Node>(count);
        for (int i = 0; i < count; ++i) {
            nodes.add(new Node<Integer>(String.valueOf(i), r.nextInt(10 * count)));
        }
        Brute brute = new Brute();
        brute.setK(10);
        brute.setSimilarity(new SimilarityInterface(){

            public double similarity(Node n1, Node n2) {
                return 1.0 / (1.0 + (double)Math.abs((Integer)n1.value - (Integer)n2.value));
            }
        });
        brute.setCallback(new CallbackInterface(){

            @Override
            public void call(HashMap<String, Object> data) {
                System.out.println(data);
            }
        });
        HashMap<Node, NeighborList> neighbor_lists = brute.computeGraph(nodes);
        for (Node n : nodes) {
            NeighborList nl = neighbor_lists.get(n);
            System.out.print(n);
            System.out.println(nl);
        }
    }

    @Override
    public HashMap<Node, NeighborList> computeGraph(List<Node> nodes) {
        int n = nodes.size();
        HashMap<Node, NeighborList> neighborlists = new HashMap<Node, NeighborList>(n);
        for (Node node : nodes) {
            neighborlists.put(node, new NeighborList(this.k));
        }
        this.computed_similarities = 0;
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (int i = 0; i < n; ++i) {
            Node n1 = nodes.get(i);
            for (int j = 0; j < i; ++j) {
                Node n2 = nodes.get(j);
                double sim = this.similarity.similarity(n1, n2);
                ++this.computed_similarities;
                neighborlists.get(n1).add(new Neighbor(n2, sim));
                neighborlists.get(n2).add(new Neighbor(n1, sim));
            }
            if (this.callback == null) continue;
            data.put("node_id", n1.id);
            data.put("computed_similarities", this.computed_similarities);
            this.callback.call(data);
        }
        return neighborlists;
    }
}

