/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs;

import info.debatty.java.graphs.CallbackInterface;
import info.debatty.java.graphs.GraphBuilder;
import info.debatty.java.graphs.Neighbor;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.Node;
import info.debatty.java.graphs.SimilarityInterface;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NNDescent
extends GraphBuilder {
    protected double rho = 0.5;
    protected double delta = 0.001;
    protected int max_iterations = Integer.MAX_VALUE;
    protected int iterations = 0;
    protected int c;

    public static void main(String[] args) {
        Random r = new Random();
        int count = 1000;
        ArrayList<Node> nodes = new ArrayList<Node>(count);
        for (int i = 0; i < count; ++i) {
            nodes.add(new Node<Integer>(String.valueOf(i), r.nextInt(10 * count)));
        }
        NNDescent nnd = new NNDescent();
        nnd.setK(10);
        nnd.setSimilarity(new SimilarityInterface(){

            public double similarity(Node n1, Node n2) {
                return 1.0 / (1.0 + (double)Math.abs((Integer)n1.value - (Integer)n2.value));
            }
        });
        nnd.setCallback(new CallbackInterface(){

            @Override
            public void call(HashMap<String, Object> data) {
                System.out.println(data);
            }
        });
        HashMap<Node, NeighborList> neighborlists = nnd.computeGraph(nodes);
        for (Node n : nodes) {
            NeighborList nl = neighborlists.get(n);
            System.out.print(n);
            System.out.println(nl);
        }
    }

    public int getC() {
        return this.c;
    }

    public int getIterations() {
        return this.iterations;
    }

    public double getRho() {
        return this.rho;
    }

    public void setRho(double rho) {
        if (rho > 1.0 || rho <= 0.0) {
            throw new InvalidParameterException("0 < rho <= 1.0");
        }
        this.rho = rho;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double delta) {
        if (this.rho >= 1.0 || this.rho <= 0.0) {
            throw new InvalidParameterException("0 < delta < 1.0");
        }
        this.delta = delta;
    }

    public int getMaxIterations() {
        return this.max_iterations;
    }

    public void setMaxIterations(int max_iterations) {
        if (max_iterations < 0) {
            throw new InvalidParameterException("max_iterations should be positive!");
        }
        this.max_iterations = max_iterations;
    }

    @Override
    public HashMap<Node, NeighborList> computeGraph(List<Node> nodes) {
        this.iterations = 0;
        if (nodes.size() <= this.k + 1) {
            return this.MakeFullyLinked(nodes);
        }
        HashMap<Node, NeighborList> neighborlists = new HashMap<Node, NeighborList>(nodes.size());
        HashMap<Node, ArrayList> old_lists = new HashMap<Node, ArrayList>(nodes.size());
        HashMap<Node, ArrayList> new_lists = new HashMap<Node, ArrayList>(nodes.size());
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Node v : nodes) {
            neighborlists.put(v, this.RandomNeighborList(nodes, v));
        }
        do {
            int i;
            Node v;
            ++this.iterations;
            this.c = 0;
            for (i = 0; i < nodes.size(); ++i) {
                v = nodes.get(i);
                old_lists.put(v, this.PickFalses((NeighborList)neighborlists.get(v)));
                new_lists.put(v, this.PickTruesAndMark((NeighborList)neighborlists.get(v)));
            }
            HashMap<Node, ArrayList> old_lists_2 = this.Reverse(nodes, old_lists);
            HashMap<Node, ArrayList> new_lists_2 = this.Reverse(nodes, new_lists);
            for (i = 0; i < nodes.size(); ++i) {
                v = nodes.get(i);
                old_lists.put(v, this.Union(old_lists.get(v), this.Sample(old_lists_2.get(v), (int)(this.rho * (double)this.k))));
                new_lists.put(v, this.Union(new_lists.get(v), this.Sample(new_lists_2.get(v), (int)(this.rho * (double)this.k))));
                for (int j = 0; j < new_lists.get(v).size(); ++j) {
                    double s;
                    Node u2;
                    int l;
                    Node u1 = (Node)new_lists.get(v).get(j);
                    for (l = j + 1; l < new_lists.get(u1).size(); ++l) {
                        u2 = (Node)new_lists.get(u1).get(l);
                        s = this.Similarity(u1, u2);
                        this.c += this.UpdateNL(neighborlists.get(u1), u2, s);
                        this.c += this.UpdateNL(neighborlists.get(u2), u1, s);
                    }
                    for (l = 0; l < old_lists.get(v).size(); ++l) {
                        u2 = (Node)old_lists.get(v).get(l);
                        if (u1.equals(u2)) continue;
                        s = this.Similarity(u1, u2);
                        this.c += this.UpdateNL(neighborlists.get(u1), u2, s);
                        this.c += this.UpdateNL(neighborlists.get(u2), u1, s);
                    }
                }
            }
            if (this.callback == null) continue;
            data.put("c", this.c);
            data.put("computed_similarities", this.computed_similarities);
            data.put("computed_similarities_ratio", (double)this.computed_similarities / (double)(nodes.size() * (nodes.size() - 1) / 2));
            data.put("iterations", this.iterations);
            this.callback.call(data);
        } while (!((double)this.c <= this.delta * (double)nodes.size() * (double)this.k) && this.iterations < this.max_iterations);
        return neighborlists;
    }

    protected ArrayList<Node> Union(ArrayList<Node> l1, ArrayList<Node> l2) {
        ArrayList<Node> r = new ArrayList<Node>();
        for (Node n : l1) {
            if (r.contains(n)) continue;
            r.add(n);
        }
        for (Node n : l2) {
            if (r.contains(n)) continue;
            r.add(n);
        }
        return r;
    }

    protected NeighborList RandomNeighborList(List<Node> nodes, Node for_node) {
        NeighborList nl = new NeighborList(this.k);
        Random r = new Random();
        while (nl.size() < this.k) {
            Node node = nodes.get(r.nextInt(nodes.size()));
            if (node.equals(for_node)) continue;
            double s = this.Similarity(node, for_node);
            nl.add(new Neighbor(node, s));
        }
        return nl;
    }

    protected ArrayList<Node> PickFalses(NeighborList neighborList) {
        ArrayList<Node> falses = new ArrayList<Node>();
        for (Neighbor n : neighborList) {
            if (n.is_new) continue;
            falses.add(n.node);
        }
        return falses;
    }

    protected ArrayList<Node> PickTruesAndMark(NeighborList neighborList) {
        ArrayList<Node> r = new ArrayList<Node>();
        for (Neighbor n : neighborList) {
            if (!n.is_new || !(Math.random() < this.rho)) continue;
            n.is_new = false;
            r.add(n.node);
        }
        return r;
    }

    protected HashMap<Node, ArrayList> Reverse(List<Node> nodes, HashMap<Node, ArrayList> lists) {
        HashMap<Node, ArrayList> R = new HashMap<Node, ArrayList>(nodes.size());
        for (Node n : nodes) {
            R.put(n, new ArrayList());
        }
        for (Node node : nodes) {
            ArrayList list = lists.get(node);
            for (Node other_node : list) {
                R.get(other_node).add(node);
            }
        }
        return R;
    }

    protected ArrayList<Node> Sample(ArrayList<Node> nodes, int count) {
        Random r = new Random();
        while (nodes.size() > count) {
            nodes.remove(r.nextInt(nodes.size()));
        }
        return nodes;
    }

    protected int UpdateNL(NeighborList nl, Node n, double similarity) {
        Neighbor neighbor = new Neighbor(n, similarity);
        return nl.add(neighbor) ? 1 : 0;
    }

    protected double Similarity(Node n1, Node n2) {
        ++this.computed_similarities;
        return this.similarity.similarity(n1, n2);
    }

    protected HashMap<Node, NeighborList> MakeFullyLinked(List<Node> nodes) {
        HashMap<Node, NeighborList> neighborlists = new HashMap<Node, NeighborList>(nodes.size());
        for (Node node : nodes) {
            NeighborList neighborlist = new NeighborList(this.k);
            for (Node other_node : nodes) {
                if (node.equals(other_node)) continue;
                neighborlist.add(new Neighbor(other_node, this.Similarity(node, other_node)));
            }
            neighborlists.put(node, neighborlist);
        }
        return neighborlists;
    }
}

