/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs;

import info.debatty.java.graphs.Edge;
import info.debatty.java.graphs.Neighbor;
import info.debatty.java.graphs.Node;
import info.debatty.java.util.BoundedPriorityQueue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeighborList
extends BoundedPriorityQueue<Neighbor>
implements Serializable {
    public static ArrayList<Edge> Convert2Edges(HashMap<Node, NeighborList> graph) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Map.Entry<Node, NeighborList> pair : graph.entrySet()) {
            for (Neighbor neighbor : pair.getValue()) {
                edges.add(new Edge(pair.getKey(), neighbor.node, neighbor.similarity));
            }
        }
        return edges;
    }

    public NeighborList(int size) {
        super(size);
    }

    public int CountCommonValues(NeighborList other_nl) {
        ArrayList other_values = new ArrayList();
        for (Neighbor n : other_nl) {
            other_values.add(n.node.value);
        }
        int count = 0;
        block1: for (Neighbor n : this) {
            Object this_value = n.node.value;
            for (Object other_value : other_values) {
                if (!other_value.equals(this_value)) continue;
                ++count;
                other_values.remove(other_value);
                continue block1;
            }
        }
        return count;
    }
}

