/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs;

import info.debatty.java.graphs.CallbackInterface;
import info.debatty.java.graphs.NNDescent;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.Node;
import info.debatty.java.graphs.SimilarityInterface;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedNNDescent
extends NNDescent {
    protected int thread_count = 4;
    private ExecutorService executor;
    List<Node> nodes;
    HashMap<Node, NeighborList> neighborlists;
    HashMap<Node, ArrayList> old_lists;
    HashMap<Node, ArrayList> new_lists;
    HashMap<Node, ArrayList> old_lists_2;
    HashMap<Node, ArrayList> new_lists_2;

    public static void main(String[] args) {
        Random r = new Random();
        int count = 1000;
        ArrayList<Node> nodes = new ArrayList<Node>(count);
        for (int i = 0; i < count; ++i) {
            nodes.add(new Node<Integer>(String.valueOf(i), r.nextInt(10 * count)));
        }
        ThreadedNNDescent tnnd = new ThreadedNNDescent();
        tnnd.setThreadCount(3);
        tnnd.setK(4);
        tnnd.setSimilarity(new SimilarityInterface(){

            public double similarity(Node n1, Node n2) {
                return 1.0 / (1.0 + (double)Math.abs((Integer)n1.value - (Integer)n2.value));
            }
        });
        tnnd.setCallback(new CallbackInterface(){

            @Override
            public void call(HashMap<String, Object> data) {
                System.out.println(data);
            }
        });
        HashMap<Node, NeighborList> neighborlists = tnnd.computeGraph(nodes);
        for (Node n : nodes) {
            NeighborList nl = neighborlists.get(n);
            System.out.print(n);
            System.out.println(nl);
        }
    }

    public void setThreadCount(int thread_count) {
        if (thread_count <= 0) {
            throw new InvalidParameterException("thread_count should be > 0");
        }
        this.thread_count = thread_count;
    }

    public int getThreadCount() {
        return this.thread_count;
    }

    @Override
    public HashMap<Node, NeighborList> computeGraph(List<Node> nodes) {
        this.executor = Executors.newFixedThreadPool(this.thread_count);
        this.iterations = 0;
        if (nodes.size() <= this.k + 1) {
            return this.MakeFullyLinked(nodes);
        }
        this.nodes = nodes;
        this.neighborlists = new HashMap(nodes.size());
        this.old_lists = new HashMap(nodes.size());
        this.new_lists = new HashMap(nodes.size());
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Node v : nodes) {
            this.neighborlists.put(v, this.RandomNeighborList(nodes, v));
        }
        do {
            ++this.iterations;
            this.c = 0;
            for (int i = 0; i < nodes.size(); ++i) {
                Node v;
                v = nodes.get(i);
                this.old_lists.put(v, this.PickFalses(this.neighborlists.get(v)));
                this.new_lists.put(v, this.PickTruesAndMark(this.neighborlists.get(v)));
            }
            this.old_lists_2 = this.Reverse(nodes, this.old_lists);
            this.new_lists_2 = this.Reverse(nodes, this.new_lists);
            ArrayList<Future<Integer>> list = new ArrayList<Future<Integer>>();
            for (int t = 0; t < this.thread_count; ++t) {
                list.add(this.executor.submit(new NNThread(t)));
            }
            for (Future future : list) {
                try {
                    this.c += ((Integer)future.get()).intValue();
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {}
            }
            if (this.callback == null) continue;
            data.put("c", this.c);
            data.put("computed_similarities", this.computed_similarities);
            data.put("iterations", this.iterations);
            data.put("computed_similarities_ratio", (double)this.computed_similarities / (double)(nodes.size() * (nodes.size() - 1) / 2));
            this.callback.call(data);
        } while (!((double)this.c <= this.delta * (double)nodes.size() * (double)this.k) && this.iterations < this.max_iterations);
        this.executor.shutdown();
        HashMap<Node, NeighborList> n = this.neighborlists;
        this.neighborlists = null;
        this.new_lists = null;
        this.new_lists_2 = null;
        this.nodes = null;
        this.old_lists = null;
        this.old_lists_2 = null;
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NNThread
    implements Callable<Integer> {
        int slice;

        public NNThread(int slice) {
            this.slice = slice;
        }

        @Override
        public Integer call() {
            int c = 0;
            int start = this.slice * ThreadedNNDescent.this.nodes.size() / ThreadedNNDescent.this.thread_count;
            int end = (this.slice + 1) * ThreadedNNDescent.this.nodes.size() / ThreadedNNDescent.this.thread_count;
            if (this.slice == ThreadedNNDescent.this.thread_count - 1) {
                end = ThreadedNNDescent.this.nodes.size();
            }
            for (int i = start; i < end; ++i) {
                Node v = ThreadedNNDescent.this.nodes.get(i);
                ThreadedNNDescent.this.old_lists.put(v, ThreadedNNDescent.this.Union(ThreadedNNDescent.this.old_lists.get(v), ThreadedNNDescent.this.Sample(ThreadedNNDescent.this.old_lists_2.get(v), (int)(ThreadedNNDescent.this.rho * (double)ThreadedNNDescent.this.k))));
                ThreadedNNDescent.this.new_lists.put(v, ThreadedNNDescent.this.Union(ThreadedNNDescent.this.new_lists.get(v), ThreadedNNDescent.this.Sample(ThreadedNNDescent.this.new_lists_2.get(v), (int)(ThreadedNNDescent.this.rho * (double)ThreadedNNDescent.this.k))));
                for (int j = 0; j < ThreadedNNDescent.this.new_lists.get(v).size(); ++j) {
                    double s;
                    Node u2;
                    int k;
                    Node u1 = (Node)ThreadedNNDescent.this.new_lists.get(v).get(j);
                    for (k = j + 1; k < ThreadedNNDescent.this.new_lists.get(u1).size(); ++k) {
                        u2 = (Node)ThreadedNNDescent.this.new_lists.get(u1).get(k);
                        s = ThreadedNNDescent.this.Similarity(u1, u2);
                        c += ThreadedNNDescent.this.UpdateNL(ThreadedNNDescent.this.neighborlists.get(u1), u2, s);
                        c += ThreadedNNDescent.this.UpdateNL(ThreadedNNDescent.this.neighborlists.get(u2), u1, s);
                    }
                    for (k = 0; k < ThreadedNNDescent.this.old_lists.get(v).size(); ++k) {
                        u2 = (Node)ThreadedNNDescent.this.old_lists.get(v).get(k);
                        if (u1.equals(u2)) continue;
                        s = ThreadedNNDescent.this.Similarity(u1, u2);
                        c += ThreadedNNDescent.this.UpdateNL(ThreadedNNDescent.this.neighborlists.get(u1), u2, s);
                        c += ThreadedNNDescent.this.UpdateNL(ThreadedNNDescent.this.neighborlists.get(u2), u1, s);
                    }
                }
            }
            return c;
        }
    }
}

