/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.build;

import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.Node;
import info.debatty.java.graphs.build.NNDescent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedNNDescent<T>
extends NNDescent<T> {
    private int cores;
    private List<Node<T>> nodes;
    private Graph<T> neighborlists;
    private HashMap<Node<T>, ArrayList> old_lists;
    private HashMap<Node<T>, ArrayList> new_lists;
    private HashMap<Node<T>, ArrayList> old_lists_2;
    private HashMap<Node<T>, ArrayList> new_lists_2;

    @Override
    protected final Graph<T> _computeGraph(List<Node<T>> nodes) {
        this.cores = Runtime.getRuntime().availableProcessors();
        ExecutorService executor = Executors.newFixedThreadPool(this.cores);
        this.iterations = 0;
        if (nodes.size() <= this.k + 1) {
            return this.MakeFullyLinked(nodes);
        }
        this.nodes = nodes;
        this.neighborlists = new Graph(nodes.size());
        this.old_lists = new HashMap(nodes.size());
        this.new_lists = new HashMap(nodes.size());
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Node<T> v : nodes) {
            this.neighborlists.put(v, this.RandomNeighborList(nodes, v));
        }
        do {
            ++this.iterations;
            this.c = 0;
            for (int i = 0; i < nodes.size(); ++i) {
                Node<T> v;
                v = nodes.get(i);
                this.old_lists.put(v, this.PickFalses(this.neighborlists.get(v)));
                this.new_lists.put(v, this.PickTruesAndMark(this.neighborlists.get(v)));
            }
            this.old_lists_2 = this.Reverse(nodes, this.old_lists);
            this.new_lists_2 = this.Reverse(nodes, this.new_lists);
            ArrayList<Future<Integer>> list = new ArrayList<Future<Integer>>();
            for (int t = 0; t < this.cores; ++t) {
                list.add(executor.submit(new NNThread(t)));
            }
            for (Future future : list) {
                try {
                    this.c += ((Integer)future.get()).intValue();
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {}
            }
            if (this.callback == null) continue;
            data.put("c", this.c);
            data.put("computed_similarities", this.computed_similarities);
            data.put("iterations", this.iterations);
            data.put("computed_similarities_ratio", (double)this.computed_similarities / (double)(nodes.size() * (nodes.size() - 1) / 2));
            this.callback.call(data);
        } while (!((double)this.c <= this.delta * (double)nodes.size() * (double)this.k) && this.iterations < this.max_iterations);
        executor.shutdown();
        Graph<T> n = this.neighborlists;
        this.neighborlists = null;
        this.new_lists = null;
        this.new_lists_2 = null;
        this.nodes = null;
        this.old_lists = null;
        this.old_lists_2 = null;
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NNThread
    implements Callable<Integer> {
        private final int slice;

        NNThread(int slice) {
            this.slice = slice;
        }

        @Override
        public Integer call() {
            int c = 0;
            int start = this.slice * ThreadedNNDescent.this.nodes.size() / ThreadedNNDescent.this.cores;
            int end = (this.slice + 1) * ThreadedNNDescent.this.nodes.size() / ThreadedNNDescent.this.cores;
            if (this.slice == ThreadedNNDescent.this.cores - 1) {
                end = ThreadedNNDescent.this.nodes.size();
            }
            for (int i = start; i < end; ++i) {
                Node v = (Node)ThreadedNNDescent.this.nodes.get(i);
                ThreadedNNDescent.this.old_lists.put(v, ThreadedNNDescent.this.Union((ArrayList)ThreadedNNDescent.this.old_lists.get(v), ThreadedNNDescent.this.Sample((ArrayList)ThreadedNNDescent.this.old_lists_2.get(v), (int)(ThreadedNNDescent.this.rho * (double)ThreadedNNDescent.this.k))));
                ThreadedNNDescent.this.new_lists.put(v, ThreadedNNDescent.this.Union((ArrayList)ThreadedNNDescent.this.new_lists.get(v), ThreadedNNDescent.this.Sample((ArrayList)ThreadedNNDescent.this.new_lists_2.get(v), (int)(ThreadedNNDescent.this.rho * (double)ThreadedNNDescent.this.k))));
                for (int j = 0; j < ((ArrayList)ThreadedNNDescent.this.new_lists.get(v)).size(); ++j) {
                    double s;
                    Node u2;
                    int k;
                    Node u1 = (Node)((ArrayList)ThreadedNNDescent.this.new_lists.get(v)).get(j);
                    for (k = j + 1; k < ((ArrayList)ThreadedNNDescent.this.new_lists.get(u1)).size(); ++k) {
                        u2 = (Node)((ArrayList)ThreadedNNDescent.this.new_lists.get(u1)).get(k);
                        s = ThreadedNNDescent.this.Similarity(u1, u2);
                        c += ThreadedNNDescent.this.UpdateNL(ThreadedNNDescent.this.neighborlists.get(u1), u2, s);
                        c += ThreadedNNDescent.this.UpdateNL(ThreadedNNDescent.this.neighborlists.get(u2), u1, s);
                    }
                    for (k = 0; k < ((ArrayList)ThreadedNNDescent.this.old_lists.get(v)).size(); ++k) {
                        u2 = (Node)((ArrayList)ThreadedNNDescent.this.old_lists.get(v)).get(k);
                        if (u1.equals(u2)) continue;
                        s = ThreadedNNDescent.this.Similarity(u1, u2);
                        c += ThreadedNNDescent.this.UpdateNL(ThreadedNNDescent.this.neighborlists.get(u1), u2, s);
                        c += ThreadedNNDescent.this.UpdateNL(ThreadedNNDescent.this.neighborlists.get(u2), u1, s);
                    }
                }
            }
            return c;
        }
    }
}

