/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.examples;

import info.debatty.java.graphs.Dijkstra;
import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.Node;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.build.Brute;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;

public class DijkstraExample {
    public static void main(String[] args) throws IOException, Exception {
        Random rand = new Random();
        ArrayList nodes = new ArrayList();
        for (int i = 0; i < 20; ++i) {
            nodes.add(new Node<Double>(String.valueOf(i), rand.nextDouble() * 100.0));
        }
        Brute<Double> builder = new Brute<Double>();
        builder.setK(10);
        builder.setSimilarity(new SimilarityInterface<Double>(){

            @Override
            public double similarity(Double value1, Double value2) {
                return 1.0 / (1.0 + Math.abs(value1 - value2));
            }
        });
        Graph graph = builder.computeGraph(nodes);
        System.out.println(graph);
        Dijkstra dijkstra = new Dijkstra(graph, nodes.get(0));
        System.out.println(dijkstra.getPath(nodes.get(1)));
        System.out.println(dijkstra.getLargestDistance());
        graph.writeGEXF("example.gexf");
    }
}

