/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.examples;

import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.build.GraphBuilder;
import info.debatty.java.graphs.build.NNCTPH;
import info.debatty.java.graphs.examples.SearchExample;
import info.debatty.java.stringsimilarity.Cosine;
import java.util.ArrayList;
import java.util.Map;

public class NNCTPHExample {
    public static void main(String[] args) {
        ArrayList nodes = GraphBuilder.readFile(SearchExample.class.getClassLoader().getResource("726-unique-spams").getFile());
        NNCTPH builder = new NNCTPH();
        builder.setNPartitions(20);
        builder.setOversampling(2);
        builder.setSimilarity(new SimilarityInterface<String>(){

            @Override
            public double similarity(String value1, String value2) {
                Cosine cosine = new Cosine(3);
                return cosine.similarity(value1, value2);
            }
        });
        Graph graph = builder.computeGraph(nodes);
        for (Map.Entry entry : graph.entrySet()) {
            System.out.println(entry);
        }
        builder.test(nodes);
    }
}

